import os

from sandbox import sdk2
from sandbox.projects.browser.common.RunFromYinTask import RunFromYinTask
from sandbox.projects.common import teamcity


class BrowserMergeCollectPullRequests(RunFromYinTask):
    class Requirements(RunFromYinTask.Requirements):
        pass

    class Parameters(RunFromYinTask.Parameters):
        branch = sdk2.parameters.String('Branch in browser repo')
        with sdk2.parameters.Group('Credentials') as credentials_group:
            robot_login = sdk2.parameters.Staff(
                'Robot login', default='robot-bro-merge')
            robot_token = sdk2.parameters.String(
                'Vault item with robot token',
                default='robot-bro-merge_token')

    def artifacts_path(self, *args):
        return self.path('artifacts', *args)

    @property
    def output(self):
        return str(self.artifacts_path('pull_requests.json'))

    def on_execute(self):
        branch = self.Parameters.branch
        if branch.startswith('refs/heads/'):
            branch = branch.split('/', 2)[-1]
        args = [
            '-vvv',
            branch, self.output,
            '--oauth-login', self.Parameters.robot_login,
            '--oauth-token-env', 'robot_token',
            '--oauth-no-save',
        ]

        os.makedirs(str(self.artifacts_path()))
        try:
            self.run_yin_script(
                'yin.merge.reports.pull_requests', args,
                extra_env=dict(
                    robot_token=sdk2.Vault.data(
                        self.Parameters.robot_token)))
        finally:
            if os.listdir(str(self.artifacts_path())):
                artifacts_resource = teamcity.TeamcityArtifacts(
                    self, 'Teamcity artifacts', self.artifacts_path())
                sdk2.ResourceData(artifacts_resource).ready()
