from sandbox import sdk2
from sandbox.projects.browser.merge.BrowserMergeNodejsTask import BrowserMergeNodejsTask


class BrowserMergeGeneralMail(BrowserMergeNodejsTask):
    class Parameters(BrowserMergeNodejsTask.Parameters):
        merge_version = sdk2.parameters.String('Merge version')
        conflicts_branch = sdk2.parameters.String('Conflicts branch')
        compilation_branch = sdk2.parameters.String('Compilation branch')
        tests_branch = sdk2.parameters.String('Tests branch')

        target_mail_list = sdk2.parameters.List(
            'Emails to send message to', sdk2.parameters.String)
        target_mail_list_str = sdk2.parameters.String(
            'Emails to send message to (space separated)')

        dry_run = sdk2.parameters.Bool('Dry run')
        use_react = sdk2.parameters.Bool('Use react')

    def on_save(self):
        if not self.Parameters.target_mail_list and self.Parameters.target_mail_list_str:
            self.Parameters.target_mail_list = [
                email.strip()
                for email in self.Parameters.target_mail_list_str.strip().split(' ')
                if email.strip()
            ]

    @property
    def output_path(self):
        return str(self.artifacts_path('mail.html'))

    def on_execute(self):
        with self.publish_artifacts() as artifacts_url:
            args = [
                '--file', self.output_path,
                self.Parameters.merge_version,
                self.Parameters.conflicts_branch,
                self.Parameters.compilation_branch,
                self.Parameters.tests_branch,
                str(self.artifacts_path()),
                artifacts_url + '/',
            ] + self.Parameters.target_mail_list

            if self.Parameters.dry_run:
                args.append('--dry-run')

            if self.Parameters.use_react:
                args.append('--react')

            self.run_yin_script('yin.merge.reports.mail.general_mail', args)
