import os

from sandbox import sdk2
from sandbox.projects.browser.common.git import repositories
from sandbox.projects.browser.merge.BrowserMergeNodejsTask import BrowserMergeNodejsTask


class BrowserMergeStatusMail(BrowserMergeNodejsTask):
    class Parameters(BrowserMergeNodejsTask.Parameters):
        merge_version = sdk2.parameters.String('Merge version')
        compilation_branch = sdk2.parameters.String('Compilation branch')
        tests_branch = sdk2.parameters.String('Tests branch')
        report_lags_to_supervisors = sdk2.parameters.Bool(
            'Report lags to supervisors', default=False)

        target_mail_list = sdk2.parameters.List(
            'Emails to send message to', sdk2.parameters.String)
        target_mail_list_str = sdk2.parameters.String(
            'Emails to send message to (space separated)')

        report_type = sdk2.parameters.String('Report type')

        dry_run = sdk2.parameters.Bool('Dry run')
        # BYIN-6648: Uncomment this.
        # use_react = sdk2.parameters.Bool('Use react')

    def on_save(self):
        if not self.Parameters.target_mail_list and self.Parameters.target_mail_list_str:
            self.Parameters.target_mail_list = [
                email.strip()
                for email in self.Parameters.target_mail_list_str.strip().split(' ')
                if email.strip()
            ]

    @property
    def output_path(self):
        return str(self.artifacts_path('mail.html'))

    def on_execute(self):
        browser_path = str(self.path('browser'))
        path_to_timeline = 'src/build/yandex/merge/merge_timeline.yaml'

        vcs_root = repositories.Stardust.browser()
        vcs_root.update_cache_repo(self.Parameters.compilation_branch)
        vcs_root.clone(
            browser_path, branch=self.Parameters.compilation_branch,
            sparse_checkout_paths=[path_to_timeline])

        args = [
            '--file', self.output_path,
            self.Parameters.merge_version,
            self.Parameters.compilation_branch,
            self.Parameters.tests_branch,
            os.path.join(browser_path, path_to_timeline),
        ] + self.Parameters.target_mail_list

        if self.Parameters.report_lags_to_supervisors:
            args.append('--report-lags-to-supervisors')

        if self.Parameters.dry_run:
            args.append('--dry-run')

        if self.Parameters.report_type:
            args += ['--report-type', self.Parameters.report_type]

        # BYIN-6648: Uncomment this.
        # if self.Parameters.use_react:
        #     args.append('--react')

        self.run_yin_script('yin.merge.reports.mail.status_mail', args)
