# coding=utf-8
import logging
import os
import time

from sandbox import sdk2
from sandbox.projects.browser.common import LXC_RESOURCE_ID
from sandbox.projects.browser.common.depot_tools import DepotToolsEnvironment
from sandbox.projects.browser.merge.BrowserMergeBase import BrowserMergeBase
from sandbox.sdk2.helpers import subprocess

ICU_PATH = 'src/third_party/icu'
UPDATE_ICU_SCRIPT_PATH = os.path.join(ICU_PATH, 'scripts', 'make_data_all.sh')


class BrowserMergeUpdateIcu(BrowserMergeBase):
    class Parameters(BrowserMergeBase.Parameters):
        branch = sdk2.parameters.String('Branch', required=True)
        reviewers = sdk2.parameters.List('Reviewers', required=True, default=['hpotter', 'anata-m'])
        _container = sdk2.parameters.Container(
            'Linux container', default_value=LXC_RESOURCE_ID)

    def on_execute(self):
        branch = self.Parameters.branch
        if branch.startswith('refs/heads/'):
            branch = branch.split('/', 2)[-1]

        self.clone_repo(branch)
        self.git_helper.fetch_and_checkout(branch)
        pr_branch = 'wp/robots/update_icu/{}'.format(int(time.time() * 1000))
        self.git.checkout('-f', '-B', pr_branch, branch)

        depot_tools_env = DepotToolsEnvironment(
            deps_file=str(self.repo_path('src', '.DEPS.snapshot')),
            dep_name='src/third_party/depot_tools',
        )
        depot_tools_env.prepare()

        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger('update_icu')) as pl:
            subprocess.check_call([self.repo_path(UPDATE_ICU_SCRIPT_PATH)],
                                  stdout=pl.stdout, stderr=subprocess.STDOUT,
                                  cwd=self.repo_path(ICU_PATH))

        if not self.git.status('--porcelain'):
            self.set_info('Nothing to update')
            return

        self.git.add('-u', ICU_PATH)
        self.git.commit('-m', 'Update ICU data')
        with sdk2.ssh.Key(self, self.Parameters.robot_ssh_key_vault, None):
            self.git.push('origin', '{}:refs/heads/{}'.format(pr_branch, pr_branch))
        pr = self.bb.create_pr('stardust', 'browser', 'Update ICU data', description='',
                               from_ref=pr_branch, to_ref=branch, reviewers=self.Parameters.reviewers)
        self.set_info('<a href="{}">Pull request</a> created successfully'.format(pr.web_url), do_escape=False)
