from sandbox import sdk2
from sandbox.projects.browser.merge.BrowserMergeNodejsTask import BrowserMergeNodejsTask


class BrowserMergeUserMail(BrowserMergeNodejsTask):
    class Parameters(BrowserMergeNodejsTask.Parameters):
        merge_version = sdk2.parameters.String('Merge version')
        conflicts_branch = sdk2.parameters.String('Conflicts branch')
        compilation_branch = sdk2.parameters.String('Compilation branch')
        tests_branch = sdk2.parameters.String('Tests branch')

        send_only_to = sdk2.parameters.List(
            'Send only to particular people', sdk2.parameters.Staff)
        send_only_to_str = sdk2.parameters.String(
            'Send only to particular people (space separated)')
        dry_run = sdk2.parameters.Bool('Dry run')

    def on_save(self):
        if not self.Parameters.send_only_to and self.Parameters.send_only_to_str:
            self.Parameters.send_only_to = [
                login.strip()
                for login in self.Parameters.send_only_to_str.strip().split(' ')
                if login.strip()
            ]

    @property
    def output_path(self):
        return str(self.artifacts_path())

    def on_execute(self):
        args = [
            self.Parameters.merge_version,
            self.Parameters.conflicts_branch,
            self.Parameters.compilation_branch,
            self.Parameters.tests_branch,
            '--output-dir', self.output_path,
        ]
        if self.Parameters.send_only_to:
            args += ['--send-only-to'] + self.Parameters.send_only_to

        if self.Parameters.dry_run:
            args.append('--dry-run')

        self.run_yin_script('yin.merge.reports.mail.user_mail', args)
