import os
from sandbox import sdk2
from sandbox.projects.browser.common.git import repositories
from sandbox.projects.browser.merge.BrowserMergeNodejsTask import BrowserMergeNodejsTask


class BrowserMergeWikiDashboard(BrowserMergeNodejsTask):
    class Parameters(BrowserMergeNodejsTask.Parameters):
        conflicts_branch = sdk2.parameters.String('Conflicts branch')
        compilation_branch = sdk2.parameters.String('Compilation branch')
        tests_branch = sdk2.parameters.String('Tests branch')

        wiki_page_owner = sdk2.parameters.Staff('Wiki page owner')

        dry_run = sdk2.parameters.Bool('Dry run')

    def on_execute(self):
        browser_path = str(self.path('browser'))
        path_to_timeline = 'src/build/yandex/merge/merge_timeline.yaml'
        vcs_root = repositories.Stardust.browser()
        vcs_root.clone(
            browser_path, branch=self.Parameters.tests_branch,
            sparse_checkout_paths=[path_to_timeline])

        args = [
            self.Parameters.conflicts_branch,
            self.Parameters.compilation_branch,
            self.Parameters.tests_branch,
            self.Parameters.wiki_page_owner,
            os.path.join(browser_path, path_to_timeline),
        ]

        if self.Parameters.dry_run:
            args.append('--dry-run')

        self.run_yin_script('yin.merge.reports.dashboard', args)
