import logging
import urlparse

from sandbox import sdk2

from sandbox.projects.browser.merge.BrowserMirrorGitRepository import BrowserMirrorGitRepository


class BrowserMirrorChromiumRepository(BrowserMirrorGitRepository):
    class Parameters(BrowserMirrorGitRepository.Parameters):
        chromium_project = sdk2.parameters.String(
            'Chromium project', required=True)

    def on_save(self):
        self.Parameters.upstream_url = urlparse.urljoin(
            'https://chromium.googlesource.com/',
            self.Parameters.chromium_project)

        if not self.Parameters.bitbucket_repo:
            self.Parameters.bitbucket_repo = \
                self.Parameters.chromium_project.replace('/', '-')
            logging.info(
                'No repository specified. Calculated from upstream one: %s',
                self.Parameters.bitbucket_repo)
