def load_python_code(content, data=None):
    '''
    Load given python code into dict and return it.
    '''

    if data is None:
        data = {}
    exec content in data
    del data['__builtins__']
    return data


class NamedCall(object):
    def __init__(self, name, args, kwargs):
        self.name = name
        self.args = args
        self.kwargs = kwargs


def format_as_python(data, indent, pretty=False, prevent_conflicts=False):
    '''
    Format key-value pairs from data as a python source.

    Use indent for indentation.
    When pretty=True will intent all dicts/lists.
    When prevent_conflicts=True will insert empty lines around dict items.
    '''

    result = ''

    def indent_text(text, indent):
        return '\n'.join(
            indent + line if line else ''
            for line in text.split('\n'))

    def vrepr(o, pretty_values=pretty, pretty_dict=False,
              insert_empty_lines=False):
        if (pretty_values or pretty_dict) and isinstance(o, dict):
            return '{{\n{}\n}}'.format(dict_repr(
                o, pretty=pretty_dict, insert_empty_lines=insert_empty_lines))
        if pretty_values and isinstance(o, list):
            return '[\n{}\n]'.format(list_repr(o))
        if isinstance(o, unicode):
            o = o.encode('utf-8')
        if isinstance(o, NamedCall):
            return '{}({})'.format(o.name, list_repr(o.args) + dict_repr(o.kwargs))
        return repr(o)

    def list_repr(l):
        body = '\n'.join(vrepr(x) + ',' for x in l)
        return indent_text(body, indent)

    def dict_repr(d, pretty=False, insert_empty_lines=False):
        if insert_empty_lines:
            pattern = '\n{}: {},\n'
            joiner = ''
        else:
            pattern = '{}: {},'
            joiner = '\n'
        body = joiner.join(
            pattern.format(repr(k), vrepr(v, pretty_values=pretty,
                                            pretty_dict=pretty))
            for k, v in sorted(d.iteritems()))
        return indent_text(body, indent)

    for name, value in sorted(data.iteritems()):
        result += '\n{} = '.format(name)
        result += vrepr(value, pretty_values=True, pretty_dict=True,
                        insert_empty_lines=prevent_conflicts)
        result += '\n'

    return result
