import logging
import os

from sandbox import sdk2


class BrowserMergeTests(sdk2.Resource):
    any_arch = True
    auto_backup = False
    calc_md5 = False
    executable = False
    releasable = False
    share = True
    ttl = "inf"


class BrowserMergeGrupperState(sdk2.Resource):
    any_arch = True
    auto_backup = False
    calc_md5 = False
    executable = False
    releasable = False
    share = True
    ttl = "inf"


def publish_merge_tests(task, description):
    if not os.path.exists(str(task.output_path)):
        # Touch a dummy file to prevent from resource break.
        with open(str(task.output_path), 'w'):
            task.set_info('WARNING: output file is empty')
    logging.debug('Ready tests resources')
    scatter_output_resource = BrowserMergeTests(task, description, task.output_path)
    sdk2.ResourceData(scatter_output_resource).ready()
    task.set_info(
        '<a href="{0}">{1}</a>'.format(scatter_output_resource.http_proxy, description),
        do_escape=False
    )
    return scatter_output_resource


def publish_merge_grupper_state(task):
    if not os.path.exists(str(task.state_path)):
        # Touch a dummy file to prevent from resource break.
        with open(str(task.state_path), 'w'):
            task.set_info('WARNING: state file is empty')
    logging.debug('Ready state resources')
    state_resource = BrowserMergeGrupperState(task, 'State file for task {}'.format(task.id),
                                              task.state_path)
    sdk2.ResourceData(state_resource).ready()
    task.set_info(
        '<a href="{0}">Link to state</a>'.format(state_resource.http_proxy),
        do_escape=False
    )
    return state_resource
