import os

from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.sandboxsdk.paths import get_logs_folder
from sandbox.sandboxsdk import process
from sandbox import sdk2

from sandbox.projects.browser.common.git import repositories
from sandbox.projects.browser.common.hpe import HermeticPythonEnvironment


class BrowserPerfYtReport(sdk2.Task):
    """Run BRYT reports"""

    class Requirements(sdk2.Requirements):
        environments = [PipEnvironment('virtualenv', '15.1.0')]

    class Parameters(sdk2.Parameters):
        kill_timeout = 15 * 60 * 60  # 15Hr

        with sdk2.parameters.Group('General settings') as general_settings:
            report_name = sdk2.parameters.String(
                'Report name',
                choices=[
                    (_, _) for _ in (
                        'stump',
                        'barnavig',
                        'weekly_histograms_report'
                    )
                ],
                default='stump',
                required=True,
            )

            params = sdk2.parameters.String("Script parameters", required=True)

            publish = sdk2.parameters.Bool("Publish report", default=False)

        _container = sdk2.parameters.Container(
            "Environment container resource",
            default_value=402010931,
            required=True
        )

        with sdk2.parameters.Group('Extra settings') as extra_settings:
            token = sdk2.parameters.String("Token vault", required=True,
                                           default='browser-yt-token')

            pulse_token = sdk2.parameters.String(
                'Pulse token vault', required=True,
                default='ROBOT_SPEEDY_PULSE_TOKEN')

            stat_user = sdk2.parameters.String("Statface client user name",
                                               required=True,
                                               default='browser-yt-stat-user')

            stat_passw = sdk2.parameters.String("Statface client password",
                                                required=True,
                                                default='browser-yt-stat-pass')

            robot_speedy_yav_token = \
                sdk2.parameters.String("YAV TOKEN", required=True,
                                       default='ROBOT_SPEEDY_YAV_TOKEN')

            branch = sdk2.parameters.String("Bryt repo branch", required=True,
                                            default='master')

    def my_path(self, *args):
        return str(self.path('bryt', *args))

    def on_execute(self):
        repositories.Stardust.bryt().clone(
            self.my_path(), self.Parameters.branch)

        with HermeticPythonEnvironment(
            python_version='2.7.17',
            pip_version='9.0.2',
            requirements_files=[sdk2.Path(self.my_path('requirements.txt'))],
            packages=['uatraits']
        ) as hpe:

            os.environ['YT_TOKEN'] = sdk2.Vault.data(self.Parameters.token)
            os.environ['PULSE_TOKEN'] = sdk2.Vault.data(
                self.Parameters.pulse_token)
            os.environ['STAT_USER'] = \
                sdk2.Vault.data(self.Parameters.stat_user)
            os.environ['STAT_PASSWORD'] = \
                sdk2.Vault.data(self.Parameters.stat_passw)
            os.environ['ROBOT_SPEEDY_YAV_TOKEN'] = sdk2.Vault.data(
                self.Parameters.robot_speedy_yav_token)
            os.environ['PYTHONPATH'] = \
                '{}:{}'.format(os.environ['PYTHONPATH'], self.my_path())

            cmd = [str(hpe.python_executable),
                   self.my_path('bryt/bin/report.py'),
                   self.Parameters.report_name,
                   self.Parameters.params,
                   '--sandbox-env',
                   '--log-dir={}'.format(get_logs_folder())]

            if self.Parameters.publish:
                cmd.append('--publish')

            process.run_process(
                cmd,
                work_dir=self.my_path(),
                log_prefix=self.Parameters.report_name,
                outputs_to_one_file=False,
                shell=True
            )
