from sandbox.common.types import client as ctc
from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.sandboxsdk import process
from sandbox import sdk2

from sandbox.projects.browser.common.git import repositories
from sandbox.projects.browser.common.hpe import HermeticPythonEnvironment


class BrowserPerfMetaInformation(sdk2.Task):
    """Upload meta information to clickhouse"""

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC
        environments = [PipEnvironment('virtualenv', '15.1.0')]

    class Parameters(sdk2.Parameters):
        kill_timeout = 10 * 60  # 10min

        with sdk2.parameters.Group('General settings') as general_settings:
            date = sdk2.parameters.String("Date (format: YYYY-MM-DD)",
                                          required=True)

            product = sdk2.parameters.String(
                'Histogram product',
                choices=[(_, _) for _ in ('browser', 'hips')],
                default='browser',
                required=True,
            )

        _container = sdk2.parameters.Container(
            "Environment container resource",
            default_value=402010931,
            required=True
        )

        with sdk2.parameters.Group('Extra settings') as extra_settings:

            branch = sdk2.parameters.String("Bryt repo branch", required=True,
                                            default='master')

            db_name = sdk2.parameters.String(
                'Database name',
                choices=[(_, _) for _ in ('performance', 'performance_test')],
                default='performance',
                required=True,
            )

    def my_path(self, *args):
        return str(self.path('bryt', *args))

    def on_execute(self):
        # only speed infra has access to the token
        # non-infra users can't run this task
        token = sdk2.Vault.data('browser-yt-token')
        del token
        repositories.Stardust.bryt().clone(
            self.my_path(), self.Parameters.branch)

        with HermeticPythonEnvironment(
            python_version='2.7.17',
            pip_version='9.0.2',
            requirements_files=[sdk2.Path(self.my_path('requirements.txt'))]
        ):

            cmd = ['fetch_from_repo',
                   '--histograms hist.json',
                   '--product', self.Parameters.product,
                   '--experiments exps.json']

            if self.Parameters.product == 'browser':
                cmd.append('--strict')

            process.run_process(
                cmd,
                work_dir=self.my_path(),
                log_prefix='fetch',
                outputs_to_one_file=False,
                shell=True
            )

            process.run_process(
                ['clickhouse_info',
                 '--db', self.Parameters.db_name,
                 '--date', self.Parameters.date,
                 '--product', self.Parameters.product],
                work_dir=self.my_path(),
                log_prefix='clickhouse_info',
                outputs_to_one_file=False,
                shell=True
            )

# 'fetch_dependencies --histograms hist.json --experiments exps.json --strict'
# clickhouse_info --db performance --date $TODAY
