import logging

MEDIA_BILLING_API_TEST = 'http://api.mt.mediabilling.yandex.net'
MEDIA_BILLING_API_PROD = 'http://api.mediabilling.yandex.net'


def schedule_transaction(session, service_ticket, production,
                         user_id, transaction_id,
                         points_campaign_id, points_amount,
                         payload):
    """
    :type session: requests.Session
    :type service_ticket: str
    :type production: bool
    :type user_id: int
    :type transaction_id: str
    :type points_campaign_id: str
    :type points_amount: int
    :type payload: dict[str, str]
    """
    api_url = MEDIA_BILLING_API_PROD if production else MEDIA_BILLING_API_TEST
    response = session.post(
        '{}/points-topup'.format(api_url),
        headers={'X-Ya-Service-Ticket': service_ticket},
        json={
            'uid': user_id,
            'transactionId': transaction_id,
            'pointsCampaignId': points_campaign_id,
            'pointsAmount': points_amount,
            'payload': payload,
        })
    response.raise_for_status()
    logging.info('Response: %s', response.json()['result'])


def get_transaction_status(session, service_ticket, production, transaction_id):
    """
    :type session: requests.Session
    :type service_ticket: str
    :type production: bool
    :type transaction_id: str
    :rtype: str
    """
    api_url = MEDIA_BILLING_API_PROD if production else MEDIA_BILLING_API_TEST
    response = session.get(
        '{}/points-topup/{}'.format(api_url, transaction_id),
        headers={'X-Ya-Service-Ticket': service_ticket})
    response.raise_for_status()
    logging.info('Response: %s', response.json()['result'])
    return response.json()['result']['status']
