from sandbox.projects.browser.release_cycle.TransitBrowserIssues.common import QueryBasedRule


class BugsRule(QueryBasedRule):

    QUEUE = 'ABRO'

    def __init__(self, new_version, *args, **kwargs):
        """
        :type new_version: str
        """
        self._new_version = new_version
        super(BugsRule, self).__init__(*args, **kwargs)

    def _query_components(self):
        return super(BugsRule, self)._query_components() + [
            'Status: Open',
            '"Fix Version": "{}"'.format(self._version),
            'Priority: Trivial, Minor, Normal',
            'Type: Bug',
        ]

    def _update_rules(self):
        return dict(fixVersions={'add': self._new_version, 'remove': self._version})
