from sandbox.projects.browser.release_cycle.TransitBrowserIssues.common import QueryBasedRule


class IssuesRule(QueryBasedRule):

    QUEUE = 'ABRO'

    def __init__(self, new_version, *args, **kwargs):
        """
        :type new_version: str
        """
        self._new_version = new_version
        super(IssuesRule, self).__init__(*args, **kwargs)

    def _query_components(self):
        return super(IssuesRule, self)._query_components() + [
            'Status: Open',
            '"Fix Version": "{}"'.format(self._version),
            'Priority: !Blocker',
            'Type: Task, Story, "Technical Story"',
        ]

    def _update_rules(self):
        return dict(fixVersions={'add': self._new_version, 'remove': self._version})


class CrashesRule(QueryBasedRule):

    QUEUE = 'ABRO'

    def __init__(self, new_version, *args, **kwargs):
        """
        :type new_version: str
        """
        self._new_version = new_version
        super(CrashesRule, self).__init__(*args, **kwargs)

    def _query_components(self):
        return super(CrashesRule, self)._query_components() + [
            'Status: Open',
            '"Fix Version": "{}"'.format(self._version),
            'Priority: Trivial, Minor, Normal',
            'Type: Crash',
        ]

    def _update_rules(self):
        return dict(fixVersions={'add': self._new_version, 'remove': self._version})
