"""
Author: Anatoly Matyukhin <amatyukhin@yandex-team.ru>
"""
from sandbox.projects.browser.release_cycle.TransitBrowserIssues.common import QueryBasedRule


class CFTransitRule(QueryBasedRule):
    def __init__(self, new_version, *args, **kwargs):
        """
        :type new_version: str
        """
        self._new_version = new_version
        super(CFTransitRule, self).__init__(*args, **kwargs)

    def _query_components(self):
        return super(CFTransitRule, self)._query_components() + [
            '"Fix Version": "{}"'.format(self._version),
            'Priority: !Blocker',
            'Status: Open, "In Progress", "In Review", Blocked, "Need Info"',
            'Tags: !zloy_crit',
        ]

    def _update_rules(self):
        return dict(
            fixVersions={'add': self._new_version, 'remove': self._version},
            tags={'add': 'cf_{}'.format(self._version)},
        )
