"""
Author: Anatoly Matyukhin <amatyukhin@yandex-team.ru>
"""
from sandbox.projects.browser.release_cycle.TransitBrowserIssues.common import QueryBasedRule


class FF2TransitRule(QueryBasedRule):
    IGNORE_COMPONENTS = {
        'AcceptanceQA',
        'Full_Tests',
    }

    def __init__(self, new_version, *args, **kwargs):
        """
        :type new_version: str
        """
        self._new_version = new_version
        super(FF2TransitRule, self).__init__(*args, **kwargs)

    def _query_components(self):
        return super(FF2TransitRule, self)._query_components() + [
            'Type: Task',
            '"Fix Version": "{}"'.format(self._version),
            'Status: Open, "In Progress", Blocked, "Need Info"',
            'Tags: !"no_ff"',
        ]

    def _update_rules(self):
        return dict(
            fixVersions={'add': self._new_version, 'remove': self._version},
            tags={'add': 'ff2_{}'.format(self._version)},
        )
