import sandbox.common.types.client as ctc
from sandbox.projects.browser.sb_lite.common.BrowserBaseSBLiteTask import BrowserBaseSBLiteTask


class BrowserSBLiteTask(BrowserBaseSBLiteTask):
    """
    Browser Sandbox Lite task.
    """

    class Requirements(BrowserBaseSBLiteTask.Requirements):
        client_tags = ctc.Tag.BROWSER & ctc.Tag.LINUX_XENIAL & ctc.Tag.SSD
        cores = 27
        disk_space = 48 * 1024
        ram = 16 * 1024

        class Caches(BrowserBaseSBLiteTask.Requirements.Caches):
            pass

    def task_extra_env(self):
        extra_env = super(BrowserSBLiteTask, self).task_extra_env()

        extra_env['NINJA_JOBS_COUNT'] = str(self.Requirements.cores)

        return extra_env
