import json

from sandbox import sdk2
from sandbox.common.errors import TaskFailure
from sandbox.common.types.task import Status
from sandbox.projects.browser.server.util.browser_wait_teamcity_build import BrowserServerWaitTeamcityBuild


VALIDATE_AB_EXPERIMENTS_BUILD_TYPE = 'BrowserA_BrowserUploads_ValidateAbExperiments'


class BrowserServerExperimentsValidateDesktop(sdk2.Task):
    """Run ab-experiments validation build for desktop experiments"""

    class Parameters(sdk2.Parameters):
        task_id = sdk2.parameters.String("Task ID", required=True)
        state_prev = sdk2.parameters.String("Previous state", required=True)
        state_cur = sdk2.parameters.String("Current state", required=True)

    def _create_child_task(self, branch):
        properties = {
            'task': self.Parameters.task_id
        }
        validate_build = BrowserServerWaitTeamcityBuild(
            self,
            description="Run validation of {} on {} branch".format(self.Parameters.task_id, branch),
            notifications=self.Parameters.notifications,
            build_type=VALIDATE_AB_EXPERIMENTS_BUILD_TYPE,
            branch=branch,
            properties=json.dumps(properties)
        )
        return validate_build

    def on_execute(self):
        with self.memoize_stage.create_children:
            subtasks = []
            if self.Parameters.state_cur == 'INBOX':
                validate_master = self._create_child_task("master")
                validate_master.enqueue()
                subtasks.append(validate_master)
            elif self.Parameters.state_cur == 'RUNNING':
                validate_production = self._create_child_task("production")
                validate_production.enqueue()
                subtasks.append(validate_production)

            raise sdk2.WaitTask(
                subtasks,
                list(Status.Group.FINISH + Status.Group.BREAK),
                wait_all=True,
            )

        for task in list(self.find()):
            if task.status != Status.SUCCESS:
                raise TaskFailure("Subtask {} failed".format(task.id))
