import sandbox.common.types.client as ctc

from sandbox.projects.browser.common.RunYinScript import RunYinScript

from sandbox import sdk2


class UploadBrowserSymbolsToSymserver(RunYinScript):
    class Requirements(RunYinScript.Requirements):
        client_tags = ctc.Tag.BROWSER & ctc.Tag.WINDOWS

    class Parameters(RunYinScript.Parameters):
        kill_timeout = 90 * 60

        with sdk2.parameters.Group('General settings') as general_settings:
            teamcity_build_id = sdk2.parameters.String('ID of parent teamcity build', required=True)

            with sdk2.parameters.String('Project') as project:
                project.values.browser = project.Value('Browser', default=True)
                project.values.antivirus = project.Value('Antivirus')

        with sdk2.parameters.Group('Credentials') as credentials_group:
            yav_token_vault = sdk2.parameters.Vault(
                'Vault item with yav token', default='robot-browser-infra_yav_token')

    secret_envvars = RunYinScript.secret_envvars + (
        'YAV_TOKEN',
    )

    def script_cmd(self, python_executable):
        module = {
            'browser': 'yin.symbol_store.upload_browser_symbols',
            'antivirus': 'yin.symbol_store.upload_antivirus_symbols',
        }[self.Parameters.project]
        return [
            str(python_executable), '-m', module,
            str(self.Parameters.teamcity_build_id),
        ]

    def script_extra_env(self):
        env = super(UploadBrowserSymbolsToSymserver, self).script_extra_env()
        env.update({
            'YAV_TOKEN': self.Parameters.yav_token_vault.data(),
        })
        return env
