import json

from sandbox import sdk2
from sandbox.projects.browser.common import binary_tasks
from sandbox.sdk2.helpers import process as sb_process


class BrowserListTasksInBinary(binary_tasks.CrossPlatformBinaryTaskMixin, sdk2.Task):

    class Requirements(sdk2.Requirements):
        disk_space = 200
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        tasks_binary_resource = sdk2.parameters.Resource('Tasks binary resource', required=True)
        tasks_prefix = sdk2.parameters.String(
            'Prefix', default='task_',
            description='Will add to binary resource attribute in format {tasks_prefix}{task_type}: True')
        _binary_task_params = binary_tasks.cross_platform_binary_task_parameters()

    def on_execute(self):
        binary_resource = sdk2.Resource.find(id=self.Parameters.tasks_binary_resource.id).first()
        binary = str(sdk2.ResourceData(self.Parameters.tasks_binary_resource).path)
        test_result = sb_process.subprocess.check_output(
            [binary, 'content', '--list-types']
        )
        task_types = json.loads(test_result)['types']
        self.set_info('Binary contains task types: {}'.format(task_types))
        for task_type in task_types:
            setattr(binary_resource, '{}{}'.format(self.Parameters.tasks_prefix, task_type), True)
