import logging

from sandbox import sdk2


class BrowserStopSandboxTasks(sdk2.Task):
    class Requirements(sdk2.Requirements):
        disk_space = 100
        cores = 1

    class Parameters(sdk2.Parameters):
        sandbox_task_ids = sdk2.parameters.List('IDs of sandbox tasks to stop', required=True)

    def on_execute(self):
        for task_id in self.Parameters.sandbox_task_ids:
            task = sdk2.Task[task_id]
            try:
                task.stop()
            except Exception:
                # The task can be finished yet, or there can be no permissions for stopping task.
                logging.exception('Failed to stop task %d', task_id)
