import logging

from sandbox import sdk2
from sandbox import common
import sandbox.common.types.client as ctc
from sandbox.sandboxsdk.environments import PipEnvironment

TEAMCITY_URL = 'https://teamcity.browser.yandex-team.ru'


class BrowserStopTeamcityBuilds(sdk2.Task):
    class Requirements(sdk2.Requirements):
        disk_space = 100
        client_tags = ctc.Tag.BROWSER  # because of teamcity access
        cores = 1
        environments = [
            PipEnvironment('teamcity-client', version='4.0.0'),
        ]

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        teamcity_build_ids = sdk2.parameters.List('Ids of teamcity builds to stop', required=True)
        cancel_comment = sdk2.parameters.String('Cancel comment', default='')
        cancel_dependencies = sdk2.parameters.Bool('Cancel snapshot dependencies', default=True)
        oauth_vault = sdk2.parameters.String('Vault item with token for teamcity',
                                             default='robot-browser-infra_teamcity_token')

    @property
    @common.utils.singleton
    def teamcity_client(self):
        from teamcity_client import client
        return client.TeamcityClient(
            server_url='teamcity.browser.yandex-team.ru',
            auth=sdk2.Vault.data(self.Parameters.oauth_vault)
        )

    def on_execute(self):
        for build_id in self.Parameters.teamcity_build_ids:
            build = self.teamcity_client.builds[build_id]
            try:
                build.cancel(self.Parameters.cancel_comment, with_dependencies=self.Parameters.cancel_dependencies)
            except Exception:
                # Probably finished build
                logging.exception('Failed to stop build %d', build_id)
