# Содержание
1. [Формат конфига](#format)
2. [Как работает схема](#internals)
3. [Не хочу читать, хочу коммитить](#commit)
4. [Известные проблемы](#issues)

Основная идея описана здесь: https://st.yandex-team.ru/BYIN-7076
Мы хотели собрать тимситёвые триггеры регулярных сборок в одном месте, описывать сборки человекочитаемым конфигом, в котором можно будет более гибко их настраивать.

Файлы конфигов лежат в папке `configs/`. Каждый файл описывает один "сценарий" запуска. Внутри файла может быть несколько блоков, описывающих какие сборки, в каком количестве и где запускать.


## <a name="format"></a>Формат
Формат файла такой:
```
<название_блока>:  # оно идёт в теги сборок, которые были запущены этим триггером, оно должно описывать, что запускается в блоке
  build_types:  # обязательное поле: id сборок (Build configuration ID), которые надо запустить
    - bt1
    - bt2
  branches:  # обязательное поле: правила для веток, по которым надо запускать сборки. Правило должно начинаться с +: для включения веток в запуск или с -: для исключения веток. Остальная часть – произвольная регулярка или словарь.
    - +:master-.*  # включение по регулярке
    - -:master-mobile  # исключение по полному совпадению
    - +:  # в случае словаря берутся ветки активных релизов (активный - если есть непройденные milestone), у которых выполняются условия по заданным фильтрам
       # возможные ключи для фильтрации:
       #    По вехам: milestone_gt (>), milestone_gte (>=), milestone_lt (<), milestone_lte (<=)
       #    По платформам: platforms
       milestone_gte: branch  # взять ветки тех релизов, у которых веха branch уже наступает/наступила
       milestone_lt: second_ff  # но не брать ветки релизов, у которых уже наступила веха second_ff
       platforms:  # необязательное поле: фильтр по платформам, реализуется проверка на наличие в списке платформ релиза хотя бы одного из элементов списка
        - mac
        - win
       count: 1  # необязательное поле: ограничивает количество веток, полученных после фильтрации. Минимальное значение - 1.
       order: desc  # необязательное поле: порядок фильтрации веток по полю версия (имеет смысл использовать только, если используется параметр count). Допустимые значения: asc, desc
  count:  # необязательное поле: количество сборок внутри этого блока для одновременного запуска. Все они запустятся на одном changeId
    10
  deps_count:  # необязательное поле: если у сборки есть зависимости, в нём указывается, сколько их одновременно нужно запустить
    5
  parameters:  # необязательное поле: можно описать словарь с параметрами, которые передадутся в каждую сборку
    par_a: 1
    par_b: "x"
  tags:  # необязательное поле: список пользовательских тегов, которые необходимо навесить на каждую сборку
    - usertag1
    - usertag2
  files:  # необязательное поле: список glob'ов фильтруемых с помощью fnmatch.filter, которые позволяют определять файлы, изменение которых должно приводить к запуску очередной сборки
    - +:*  # Включающие правила начинаются с подстроки "+:", за которой следуюет glob
    - -:*/platform-specific/*  # Выключающие правила, в свою очередь начинаются с подстроки "-:"
    - +:*/platform-specific/still-used-by-every-platform/*  # Чем позже (ниже) определено правило, тем бОльший у него приоритет. Это позволяет задавать какие-то общие выключающие правила,
                                                            # но при этом в случае необходимости включать какие-то специфичные файлы/директории-исключения
  run_with_no_changes: false  # необязательное поле: позволяет запускать сборки в случае если с момента последнего запуска не было внесено изменений
```


## <a name="internals"></a>Как работает схема
Для каждого файла есть сборка в тимсити, которая запускает в SB основной скрипт: [BROWSER_CONFIGURABLE_TEAMCITY_TRIGGER](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/browser/util/configurable_trigger/BrowserConfigurableTeamcityTrigger/__init__.py). В тимсити должен быть указан один и только один _VCS Root: тот, по которому триггерятся сборки из конфига_. Скорее всего, вам нужен `(git) stardust/browser.git`.

Пример сборки: [запуск юнит-тестов раз в три часа](https://teamcity.browser.yandex-team.ru/viewType.html?buildTypeId=Browser_Tests_TriggerUnitTests).

Для нашего триггера всё равно нужно указывать Schedule/VCS Root Trigger в тимсити, чтобы запускать правила регулярно :) 

Наш триггер запустится как обычная сборка в тимсити: в тимситёвом триггере можно указать расписание запуска, отслеживание изменений, имена веток и проч. Далее, уже в SB наш триггер пройдётся по всем блокам в файле и попытается применить регулярки на имя ветки, на которой он запустился. Регулярки он просматривает _снизу вверх_, как тимсити. Если правила из блока матчат ветку, то он запустит указанные в блоке билды в нужном количестве по этой ветке. Если нет, то есть ветка запуска не подходит ни под одно правило, или она специально исключена через `-:`, то ничего не будет. Ветка может попасть в правила из нескольких блоков, это ожидаемо. К каждой запущенной сборке добавляются тэги `trigger:<имя_файла>, trigger:<имя_файла>:<имя_блока>`. 

В качестве changeId для запускаемых сборок берётся последний для ветки, по которой запустился триггер. Он пробрасывается во все сборки и их deps. Именно поэтому необходимо, чтобы VCS Root триггера и сборок совпадал.

### Как запускаются зависимости
Можно заметить, что в наших конфигах `deps_count < count`. Это сделано потому что из любой зависимости (snapshot dependency) можно "промоутить" любое число билдов. Подробнее о promoting: https://www.jetbrains.com/help/teamcity/triggering-a-custom-build.html#TriggeringaCustomBuild-PromotingBuild

В этом месте наш триггер работает немного хитро:
1. запускает `deps_count` (основных) билдов, указанных в `build_types`
2. тимсити видит, что у них есть snapshot dependencies, запускает их
3. скрипт через API берёт у тимсити id запущенных зависимых сборок. К этому моменту они могли не завершиться!
4. скрипт запускает дополнительно `count - deps_count` основных билдов, каждый из них промоутится от какой-то зависимости
5. скрипт записывает id всех основных билдов и ждёт их завершения
Возможно, что какая-то из зависимостей упадёт – тогда основные сборки, промоученные от неё, тоже могут упасть.


## <a name="commit"></a>Как менять конфиги
Для добавления сборок в файлы нужно делать ПР, в нём небольшой валидатор проверит, что нет ошибок формата, и регулярки корректны.

### Добавить больше сборок к существующим правилам
Выбираете нужный вам файл конфига, смотрите, что там уже есть. Возможно, в нужный вам блок нужно дописать новый build configuration ID, или добавить ещё одну ветку. Возможно, вам нужно создать новый блок в файле или разделить существующий на два.
### Добавить новый файл
Рекомендуется прочитать раздел [Как работает схема](#internals) перед созданием ПРа и всего остального.

Создаёте файл с именем, описывающим "сценарий". Прописываете в нём все нужные вам блоки.

Когда ПР влился, делаете в тимсити новую сборку. Выбираете VCS Root, по которому будут запускаться сборки из конфига, настраиваете триггеры по расписанию или покоммитно. 

1. Добавляете `Build Feature`: `Sandbox Task Launcher`. Подробнее: https://wiki.yandex-team.ru/browser/dev/infra/docs/browser-testing/sandbox/
	1. `sandbox_task_type`: `BROWSER_CONFIGURABLE_TEAMCITY_TRIGGER`
	2. `parameters_prefix`: `sandbox.` (точка важна)
	3. остальные поля – на ваше усмотрение
2. Добавляете параметр типа `Configuration parameter`. `Name`: `sandbox.config_path`, `value`: <имя файла конфига относительно папки configs>


## <a name="issues"></a>Известные проблемы
Чего тут не хватает:
1. указания пула для запускаемых сборок
