SCHEMA = {
    '$schema': 'http://json-schema.org/draft-07/schema#',
    'type': 'object',
    'additionalProperties': {
        'type': 'object',
        'required': [
            'build_types',
            'branches',
        ],
        'properties': {
            'build_types': {
                'type': 'array',
                'minItems': 1,
                'items': {
                    'type': 'string',
                },
                'uniqueItems': True,
            },
            'branches': {
                'type': 'array',
                'minItems': 1,
                'items': {
                    'anyOf': [
                        {
                            'type': 'string',
                        },
                        {
                            'type': 'object',
                            'oneOf': [
                                {
                                    'required': [
                                        '+',
                                    ],
                                },
                                {
                                    'required': [
                                        '-',
                                    ],
                                },
                            ],
                            'properties': {
                                '+': {
                                    '$ref': '#/definitions/branch_filter',
                                },
                                '-': {
                                    '$ref': '#/definitions/branch_filter',
                                },
                            },
                        },
                    ],
                },
                'uniqueItems': True,
            },
            'count': {
                'type': 'number',
            },
            'deps_count': {
                'type': 'number',
            },
            'parameters': {
                'type': 'object',
                'additionalProperties': {
                    'type': ['string', 'number', 'boolean']
                }
            },
            'tags': {
                'type': 'array',
                'items': {
                    'type': 'string',
                },
            },
            'files': {
                'type': 'array',
                'items': {
                    'type': 'string',
                },
                'uniqueItems': True,
            },
            'run_with_no_changes': {
                'type': 'boolean'
            }
        },
        'additionalProperties': False,
    },

    'definitions': {
        'branch_filter': {
            'type': 'object',
            'allOf': [
                {
                    'oneOf': [
                        {
                            'required': [
                                'milestone_gt',
                            ],
                        },
                        {
                            'required': [
                                'milestone_gte',
                            ],
                        },
                    ],
                },
                {
                    'oneOf': [
                        {
                            'required': [
                                'milestone_lt',
                            ],
                        },
                        {
                            'required': [
                                'milestone_lte',
                            ],
                        },
                    ],
                },
            ],
            'properties': {
                'milestone_gt': {
                    'type': 'string',
                },
                'milestone_gte': {
                    'type': 'string',
                },
                'milestone_lt': {
                    'type': 'string',
                },
                'milestone_lte': {
                    'type': 'string',
                },
                'platforms': {
                    'type': 'array',
                    'items': {
                        'type': 'string',
                    },
                },
                'count': {
                    'type': 'integer',
                    'minimum': 1,
                },
                'order': {
                    'type': 'string',
                    'pattern': '^(desc|asc)$',
                },
            },
            'additionalProperties': False,
        },
    },
}
