"""
Sandbox task that provides implementation of sandbox-lite-api for browser-android builds.
See: https://bitbucket.browser.yandex-team.ru/projects/MBROINFRA/repos/sandbox-integration/
See: https://teamcity.browser.yandex-team.ru/project.html?projectId=Browser_AndroidBuilds_SandboxLite
"""

from sandbox import sdk2
from sandbox.projects.browser.common import depot_tools
from sandbox.projects.browser_mobile.abro import sandbox_lite_task
from sandbox.sandboxsdk.environments import SandboxEnvironment


class BrowserAndroidBuild(sandbox_lite_task.BrowserAndroidSandboxLiteTask):
    class Parameters(sandbox_lite_task.BrowserAndroidSandboxLiteTask.Parameters):
        with sdk2.parameters.Group('Credentials') as credentials_group:
            yav_token_vault = sdk2.parameters.String(
                'Vault item with YAV OAuth token.',
                default='robot-browser-infra_yav_token')

    def get_cache_dir(self):
        return SandboxEnvironment.exclusive_build_cache_dir('browser')

    def get_task_environ(self):
        task_environ = super(BrowserAndroidBuild, self).get_task_environ()
        task_environ['YAV_TOKEN'] = sdk2.Vault.data(self.Parameters.yav_token_vault)
        return task_environ

    def on_prepare(self):
        super(BrowserAndroidBuild, self).on_prepare()
        depot_tools.DepotToolsEnvironment().prepare()
