"""
Sandbox task that provides implementation of sandbox-lite-api for browser recipe builds.
See: https://bitbucket.browser.yandex-team.ru/projects/MBROINFRA/repos/sandbox-integration/
"""

import multiprocessing
import os

import sandbox.common.types.client as ctc
from sandbox.common import config
from sandbox.projects.browser_mobile.abro.BrowserAndroidBuild import BrowserAndroidBuild


class BrowserSandboxLiteTask(BrowserAndroidBuild):
    """ Provides implementation of sandbox-lite-api """

    class Requirements(BrowserAndroidBuild.Requirements):
        client_tags = ctc.Tag.BROWSER & ctc.Tag.LINUX_XENIAL & ctc.Tag.CORES56

    class Parameters(BrowserAndroidBuild.Parameters):
        kill_timeout = 60 * 60 * 6

    def init_environment(self):
        super(BrowserSandboxLiteTask, self).init_environment()
        ninja_jobs = multiprocessing.cpu_count() / config.Registry().client.max_job_slots
        os.environ.update({
            'NINJA_JOBS_COUNT': str(ninja_jobs),
        })
