"""
Author: Vladimir Stefanovskiy <stef@yandex-team.ru>
"""
import os

from sandbox import sdk2
import sandbox.common.types.client as ctc
from sandbox.sandboxsdk.environments import VirtualEnvironment


class BrowserMobileBackupSonar(sdk2.Task):

    class Parameters(sdk2.Parameters):
        kill_timeout = 3600
        project = sdk2.parameters.String(
            'Qloud project', required=True)
        app = sdk2.parameters.String(
            'Qloud application', required=True)
        env = sdk2.parameters.String(
            'Qloud environment', required=True)
        version_to_deploy = sdk2.parameters.String(
            'Environment version to deploy', required=True)

    class Requirements(sdk2.Requirements):
        client_tags = ctc.Tag.BROWSER & ctc.Tag.LINUX_TRUSTY

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        with VirtualEnvironment() as venv:
            venv.pip('qloud-pain==0.0.0')
            activate_this = os.path.join(venv.root_dir, 'bin', 'activate_this.py')
            execfile(activate_this, dict(__file__=activate_this))

            from qloud.simple_api import SimpleApi
            api = SimpleApi()
            api.auth(login='robot-mbro-infra', password=sdk2.Vault.data('ROBOT_MBRO_INFRA_PASSWORD'))
            env = api.environment(
                project=self.Parameters.project,
                application=self.Parameters.app,
                environment=self.Parameters.env)
            env.deploy_version(self.Parameters.version_to_deploy, '')
