"""
Author: Vladimir Stefanovskiy <stef@yandex-team.ru>
"""
import os

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess, ProcessLog
import sandbox.common.types.client as ctc
from sandbox.sandboxsdk.environments import VirtualEnvironment


TASK_DIR = os.path.dirname(os.path.abspath(__file__))
REQUIREMENTS_PATH = os.path.join(TASK_DIR, 'requirements.txt')
EVICT_SCRIPT = os.path.join(TASK_DIR, 'evict_ccache.py')
DEFAULT_MONGO_URI = (
    'mongodb://repl-browser-mobile-ccache-v1.repl.ccache.mongo.browser-mobile.'
    'stable.qloud-d.yandex.net:27017,repl-browser-mobile-ccache-v2.repl.'
    'ccache.mongo.browser-mobile.stable.qloud-d.yandex.net:27017'
    '/ccache?replicaSet=rs')
DEFAULT_TARGET_SIZE_GB = 500
DEFAULT_DROP_BATCH = 100


class BrowserMobileEvictCcache(sdk2.Task):

    class Parameters(sdk2.Parameters):
        kill_timeout = 3600
        target_size_gb = sdk2.parameters.Integer(
            'Target cache size in GiB', default=DEFAULT_TARGET_SIZE_GB)
        drop_batch = sdk2.parameters.Integer(
            'Number of records to drop in one batch',
            default=DEFAULT_DROP_BATCH)
        mongo_uri = sdk2.parameters.String(
            'Mongodb URI', default=DEFAULT_MONGO_URI)

    class Requirements(sdk2.Requirements):
        client_tags = ctc.Tag.BROWSER & ctc.Tag.LINUX_TRUSTY

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        target_size = self.Parameters.target_size_gb * (1024 * 1024 * 1024)
        with VirtualEnvironment() as venv:
            venv.pip('-r ' + REQUIREMENTS_PATH)
            with ProcessLog(self, 'evict_ccache') as log:
                subprocess.check_call([
                    venv.executable, EVICT_SCRIPT,
                    '--drop-batch', str(self.Parameters.drop_batch),
                    '--target-size', str(target_size),
                    '--mongo-uri', self.Parameters.mongo_uri],
                    stdout=log.stdout, stderr=log.stderr)
