import logging
from sandbox import sdk2
import os
from sandbox.sdk2.helpers import subprocess as sp
import sandbox.common.types.misc as ctm


class BsOutdoorProgramCountSchedule(sdk2.Task):

    class Requirements(sdk2.Task.Requirements):
        dns = ctm.DnsType.DNS64

    class Parameters(sdk2.Task.Parameters):
        booking_id = sdk2.parameters.String("BookingId")
        edition_id = sdk2.parameters.Integer("EditionId")
        resource_id = sdk2.parameters.Integer("BinaryResourceId")
        yt_log_cluster = sdk2.parameters.String("YtLogCluster", default='hahn')
        yt_read_cluster = sdk2.parameters.String("YtReadCluser", default='hahn')
        yt_write_cluster = sdk2.parameters.String("YtWriteCluster", default='hahn')
        yt_prefix = sdk2.parameters.String("YtPrefix", default='//home/bs-outdoor/preprod/')
        recalculate = sdk2.parameters.String("Recalculate", default=None)
        old_edition_id = sdk2.parameters.String("OldEditionId", default=None)

    def on_execute(self):
        resource_id = self.Parameters.resource_id
        res = sdk2.ResourceData(list(sdk2.Resource.find(id=resource_id).limit(1))[0])

        booking_id = self.Parameters.booking_id
        edition_id = self.Parameters.edition_id
        yt_read_cluster = self.Parameters.yt_read_cluster
        yt_write_cluster = self.Parameters.yt_write_cluster
        yt_log_cluster = self.Parameters.yt_log_cluster
        yt_prefix = self.Parameters.yt_prefix
        recalculate = self.Parameters.recalculate
        old_edition_id = self.Parameters.old_edition_id

        logging.info(booking_id, edition_id, str(res.path))
        with sdk2.helpers.ProcessLog(self, logger='program') as pl:
            env = os.environ.copy()
            env['YT_TOKEN'] = sdk2.Vault.data('bs_outdoor_yt_token')
            run = [
                str(res.path),
                "-b", booking_id,
                "-e", str(edition_id),
                "--yt-read-cluster", yt_read_cluster,
                "--yt-write-cluster", yt_write_cluster,
                "--yt-log-cluster", yt_log_cluster,
                "--yt-prefix", yt_prefix,
            ]
            if recalculate and old_edition_id:
                run += [
                    '-r',
                    '-o', old_edition_id,
                ]
            ret = sp.Popen(run, stdout=pl.stdout, stderr=sp.STDOUT, env=env).wait()
            if ret:
                raise RuntimeError("Ret code %d" % ret)
