from sandbox import sdk2
from sandbox.projects.common.build.KosherYaPackage import KosherYaPackage
from sandbox.projects.release_machine.helpers.startrek_helper import STHelper
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.components import all as rmc
from sandbox.projects.common.constants.constants import ARCADIA_URL_KEY
from sandbox.projects.common import error_handlers as eh
from sandbox.projects.release_machine.core import task_env
from sandbox.projects.common.sdk_compat import task_helper
import sandbox.common.types.client as ctc
import logging
import re


class BuildBigbPackage(KosherYaPackage):
    class Requirements(sdk2.Requirements):
        environments = (
            task_env.TaskRequirements.startrek_client,
        )
        client_tags = ctc.Tag.LXC | ctc.Tag.ARCADIA_HG | (task_env.TaskTags.all_rm & task_env.TaskTags.startrek_client)

    def get_bigb_release_info(self):
        build_arc_url = task_helper.input_or_ctx_field(task_helper.task_obj(self.id), ARCADIA_URL_KEY)
        m = re.match(r".*/(?P<component_name>\S+)\/stable-(?P<release_version>[0-9]+-[0-9]+).*", build_arc_url)
        if m is None:
            raise Exception("Failed to get release info from resource")
        return m.group("component_name"), m.group("release_version")

    def on_execute(self):
        super(BuildBigbPackage, self).on_execute()

        try:
            component_name, release_version = self.get_bigb_release_info()

            logging.info("Got release: %s", release_version)

            st_helper = STHelper(sdk2.Vault.data(rm_const.COMMON_TOKEN_OWNER, rm_const.COMMON_TOKEN_NAME))
            c_info = rmc.COMPONENTS[component_name]()

            resource_id = self.Context.package_resources["resources"][0][0]

            sdk2.Resource[resource_id].released = "stable"

            content = "[{component_name}]\n"\
                      "New minor release {release_version} was successfully built: "\
                      "https://sandbox.yandex-team.ru/resource/{resource_id}/view"\
                      .format(resource_id=resource_id, component_name=component_name, release_version=release_version)
            logging.info("Post to startrack content: %s", content)

            major_release = release_version.split("-")[0]

            st_helper.comment(
                release_num=major_release,
                text=content,
                c_info=c_info
            )
        except Exception as exc:
            eh.log_exception("Unable to write comment about build", exc)
