from sandbox import sdk2
from sandbox.projects import resource_types
from sandbox.projects.common.build.YaPackage import YaPackageResource
import os
import tempfile
import time


advanced_releasers = [
    "mikari", "zomb-yeti"
]

BSYETI_AUTHORS = [
    "mikari", "cberg", "kmekhovich", "random-login",
    "pechatnov", "igorsolovyev",
    "dancingqueue", "bulatman", "mafanasev", "leasid", "svkrasnov",
    "ogstepanov", "ionagamed",
    "zomb-yeti", "robot-srch-releaser", "robot-testenv",
]  # THIS PLACE IS NOT EXCLUSIVE, COPYPASTE IN ANOTHER FILES

basic_releasers = advanced_releasers + BSYETI_AUTHORS


class BasicBsyetiSamogonPackage(sdk2.Resource):
    auto_backup = True
    calc_md5 = True
    share = True
    auto_backup = True
    releasers = basic_releasers
    release_subscribers = ["mikari", "bsyeti-watcher"]
    releasable = True


class BigbBalancerSamogonPackage(BasicBsyetiSamogonPackage):
    """
    bigb fast l7 balancer samogon package (separate installation)
    """
    releasers = advanced_releasers


class BigbShooterSamogonPackage(BasicBsyetiSamogonPackage):
    """
    bigb shooter samogon package
    """


class BigbEagleLayer(BasicBsyetiSamogonPackage):
    """
    bigb eagle layer for deploy
    """


class BigbDatagramReceiverLayer(BasicBsyetiSamogonPackage):
    """
    bigb datagram receiver layer for deploy
    """


class BigbShooterLayer(BasicBsyetiSamogonPackage):
    """
    bigb shooter layer for deploy
    """


class BigbProfilerLayer(BasicBsyetiSamogonPackage):
    """
    bigb profiler layer for deploy
    """


class BsyetiSvnResources(BasicBsyetiSamogonPackage):
    """
    bsyeti svn resources
    """


class BsyetiSamogonPackage(BasicBsyetiSamogonPackage):
    """
    bsyeti samogon package (big trash can installation)
    """


class BuzzardSamogonPackage(BasicBsyetiSamogonPackage):
    """
    buzzard samogon package
    """
    releasers = basic_releasers


class EagleSamogonPackage(BasicBsyetiSamogonPackage):
    """
    eagle samogon package (separate installation)
    """
    releasers = basic_releasers


class ResharderSamogonPackage(BasicBsyetiSamogonPackage):
    """
    resharder samogon package (separate installation)
    """


class VultureSamogonPackage(BasicBsyetiSamogonPackage):
    """
    resharder samogon package (separate installation)
    """


class BigbTelegramBotSamogonPackage(BasicBsyetiSamogonPackage):
    """
    bigb telegram bot samogon package (separate installation)
    """


class BigbLogSamplerSamogonPackage(BasicBsyetiSamogonPackage):
    """
    bigb log sampler samogon package
    """


class BigbDevMachineSamogonPackage(BasicBsyetiSamogonPackage):
    """
    bigb dev machine samogon package
    """


class BigbEagleConfigs(BasicBsyetiSamogonPackage):
    """
    eagle configs
    """


class BigbResharderBlackList(BasicBsyetiSamogonPackage):
    """
    resharder profile ids black list
    """


class BigbCodecsFolder(BasicBsyetiSamogonPackage):
    """
    zstd-dicts folder
    """


class CatalogiaDssmModel(sdk2.Resource):
    """
    dssm model and categories for neural catalogia
    """
    any_arch = True
    auto_backup = True
    releasers = ["robot-ads-nn"]


class DiversityDssmModel(sdk2.Resource):
    """
    dssm model for diversity in eagle and buzzard
    """
    any_arch = True
    auto_backup = True
    releasers = basic_releasers + ["wu-mi"]


class BigbWbcLmSoftmaxGraphBuilder(sdk2.Resource):
    """
    wbc linear model graph builder
    """
    releasable = True
    releasers = basic_releasers
    release_subscribers = ["mstebelev", "bsyeti-watcher"]


class BigbUdf(sdk2.Resource):
    auto_backup = True
    calc_md5 = True
    share = True
    auto_backup = True
    releasers = basic_releasers
    release_subscribers = ["bsyeti-watcher"]
    releasable = True


class RsyaSimilarBannersBases(sdk2.Resource):
    auto_backup = True
    calc_md5 = True
    share = True
    auto_backup = True
    releasers = basic_releasers + ["jruziev", "insight"]
    release_subscribers = ["jruziev", "insight", "bsyeti-watcher"]
    releasable = True


class BigbOracleSamogonPackage(BasicBsyetiSamogonPackage):
    """
    bigb oracle samogon package
    """


class ValidatorForAbCheckerBin(resource_types.ARCADIA_PROJECT):
    """
    resource with ads/bsyeti/servants/validator_for_ab/checker binary
    """
    auto_backup = True
    any_arch = True
    releasers = basic_releasers
    release_subscribers = ["pechatnov"]
    releasable = True


class BigbExperimentsInfoBin(resource_types.ARCADIA_PROJECT):
    """
    resource with ads/bsyeti/servants/experiments_viewer/viewer binary
    """
    auto_backup = True
    any_arch = True
    releasers = basic_releasers
    release_subscribers = ["pechatnov"]
    releasable = True


class BigbRavenSamogonPackage(BasicBsyetiSamogonPackage):
    """
    bigb raven samogon package
    """


class BigbJaylogSamogonPackage(BasicBsyetiSamogonPackage):
    """
    bigb jaylog samogon package
    """


class CaesarSamogonPackage(BasicBsyetiSamogonPackage):
    """
    caesar samogon package
    """


class CaesarResharderSamogonPackage(BasicBsyetiSamogonPackage):
    """
    caesar resharder samogon package
    """


class BsyetiUpdateTurboUrlDictPackage(sdk2.Resource):
    """
    resource with ads/bsyeti/caesar/bin/update_turbo_url_dict binary and configs
    """
    releasable = True
    auto_backup = True
    releasers = basic_releasers + ["adygamovilyas"]


class BsyetiUpdateMobileAppPackage(sdk2.Resource):
    """
    resource with ads/bsyeti/caesar/bin/update_mobile_app binary and configs
    """
    releasable = True
    auto_backup = True
    releasers = basic_releasers + ["thenno"]


class LongAbExperimentsConfig(sdk2.Resource):
    """
    long config of ab experiments. Contains configs for last N days
    """
    any_arch = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = basic_releasers


class LongestAbExperimentsConfig(sdk2.Resource):
    """
    long config of ab experiments. Contains configs for last N days
    """
    any_arch = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = basic_releasers


class BigRtQueueDaemonSamogonPackage(BasicBsyetiSamogonPackage):
    """
    public queue daemon samogon package
    """


class BigbSoloCreator(YaPackageResource):
    """
    SOLO creator package
    """
    auto_backup = True
    releasable = True
    releasers = basic_releasers
    calc_md5 = True
    share = True


class BigbFlamegraphPlotterBin(resource_types.ARCADIA_PROJECT):
    """
    resource with flamegraph drawing binary
    """

    releasable = True
    any_arch = True
    auto_backup = True
    releasers = basic_releasers
    release_subscribers = basic_releasers


class BigbBufImage(sdk2.Resource):
    """
    buf build result of some important protobufs to check compatibility on changing
    """
    releasable = True
    auto_backup = True
    releasers = basic_releasers


class BigbFlamegraphViewerSamogonPackage(sdk2.Resource):
    """
    bigb flamegraph viewer samogon package
    """


def get_yt_token_path():
    token = sdk2.Vault.data('BSYETI', 'YT_STORE_TOKEN')
    token_path = tempfile.NamedTemporaryFile().name
    with open(str(token_path), 'w') as f:
        f.write(token)
    return token_path


def dump_timestamp(folder, t=None):
    if t is None:
        t = time.time()
    with open(os.path.join(folder, "timestamp"), "w") as f:
        print >>f, int(t)
