import os
import subprocess

from sandbox.projects.common.BaseCompareYaMakeOutputsTask import \
    BaseCompareYaMakeOutputsTask


class CaesarB2BTestCompareOutputs(BaseCompareYaMakeOutputsTask):
    def compare(self, build_output1, build_output2, testing_out_stuff_dir):
        path = "ads/bsyeti/caesar/tests/b2b/diff_test/test-results/py3test/testing_out_stuff/profiles.json"
        file_lhs = os.path.join(build_output1, path)
        file_rhs = os.path.join(build_output2, path)
        p = subprocess.Popen(
            [
                "diff",
                "-u",
                file_lhs,
                file_rhs
            ],
            stdout=subprocess.PIPE,
            stderr=subprocess.PIPE,
            env=os.environ
        )
        out, err = p.communicate()

        if p.returncode == 1:
            return out or err
        if p.returncode != 0:
            return err
