import logging
import os
import subprocess

from sandbox.projects.bsyeti.common import get_yt_token_path
from sandbox.projects.common import vcs
from sandbox.projects.common.BaseCompareYaMakeOutputsTask import \
    BaseCompareYaMakeOutputsTask


def fetch_output(path):
    proto_path = os.path.join(path, "proto")
    return {
        "proto": {v: os.path.join(proto_path, v) for v in os.listdir(proto_path)},
    }


class BigbEagleCanonizeUtCompare(BaseCompareYaMakeOutputsTask):

    def compare(self, build_output1, build_output2, testing_out_stuff_dir):
        path = "ads/bsyeti/tests/eagle/canonize_ut_diff_test/test-results/py3test/testing_out_stuff/output"
        file_lhs = os.path.join(build_output1, path)
        file_rhs = os.path.join(build_output2, path)
        output_lhs = fetch_output(file_lhs)
        output_rhs = fetch_output(file_rhs)
        arc = vcs.arc.Arc()
        compare_proto = "ads/bsyeti/tests/test_lib/eagle_compare/bin"
        with arc.mount_path("", changeset="trunk", fetch_all=False) as arc_path:
            token_path = get_yt_token_path()
            typ2cmp = {
                "proto": os.path.join(arc_path, compare_proto)
            }
            ya = os.path.join(arc_path, "ya")
            os.chdir(arc_path)
            logging.info("run yamake")
            subprocess.check_call([ya, "make", "-r", "--yt-store", "--yt-store-threads", "8", "--yt-token-path", token_path, compare_proto])
            logging.info("arc path %s", arc_path)
            diffs = []
            for typ, compare_binary in typ2cmp.items():
                os.chdir(compare_binary)
                left_files = set(output_lhs[typ]) - set(output_rhs[typ])
                right_files = set(output_rhs[typ]) - set(output_lhs[typ])
                common_files = set(output_rhs[typ]) & set(output_lhs[typ])
                for f in left_files:
                    diffs.append("%s disappeared" % f)
                for f in right_files:
                    diffs.append("%s is new" % f)
                for f in common_files:
                    execline = [
                        os.path.join(compare_binary, "compare"),
                        output_lhs[typ][f],
                        output_rhs[typ][f]
                    ]
                    logging.info("executing %s in %s", execline, os.getcwd())
                    p = subprocess.Popen(
                        execline,
                        stdout=subprocess.PIPE,
                        stderr=subprocess.PIPE,
                        env=os.environ
                    )
                    out, err = p.communicate()
                    out = out.decode("utf8")
                    err = err.decode("utf8")
                    if p.returncode != 0:
                        diffs.append(out + err)
            if diffs:
                return "\n".join(diffs).encode("utf8")
