# -*- coding: utf-8 -*-

from sandbox import sdk2
import sandbox.common.types.resource as ctr
import sandbox.common.types.client as ctc
import sandbox.projects.resource_types as rt

from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.bsyeti.common import basic_releasers


class BigbCleanupBin(rt.ARCADIA_PROJECT):
    """
    resource with sandbox cleanup bin
    """

    releasable = True
    any_arch = True
    auto_backup = True
    releasers = basic_releasers
    release_subscribers = ["igorsolovyev"]


class BigbDoCleanup(sdk2.Task):
    """
    task to build json configs for bsyeti
    """

    class Requirements(sdk2.Requirements):
        cores = 1  # exactly 1 core
        ram = 8192  # 8GiB or less
        client_tags = ctc.Tag.GENERIC   # Maybe, will override old values

    class Caches(sdk2.Requirements.Caches):
        pass  # means that task do not use any shared caches

    class Parameters(sdk2.Parameters):
        binary_id = sdk2.parameters.LastReleasedResource(
            'do cleanup binary resource',
            resource_type=BigbCleanupBin,
            state=(ctr.State.READY, ),
            required=True
        )
        config_name = sdk2.parameters.String(
            "Config name and env",
            required=True,
            do_not_copy=True
        )

    def on_execute(self):
        bin_res = sdk2.ResourceData(self.Parameters.binary_id)
        env = {
            "YT_TOKEN": sdk2.Vault.data("sec-01djab78jh9dvsymnjzwhk1mpf[yt_token]"),  # "zomb-yeti" secret from yav
            "YT_USER": "zomb-yeti",
            "TMP": ".",
            "TMPDIR": ".",
        }
        cmd = [
            str(bin_res.path),
            "-c", "/configs" + self.Parameters.config_name,
        ]
        with sdk2.helpers.ProcessLog(self, logger="bigb_do_cleanup") as l:
            sp.check_call(cmd, stdout=l.stdout, stderr=l.stderr, env=env)
