# -*- coding: utf-8 -*-

from sandbox import sdk2
import os
import time
import sandbox.common.types.resource as ctr
import sandbox.projects.resource_types as rt

from sandbox.common.types.client import Tag
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.bsyeti.common import dump_timestamp, basic_releasers


class BsYetiMakeLightConfigsBin(rt.ARCADIA_PROJECT):
    """
    resource with make_bsyeti_light_configs bin
    """

    releasable = True
    any_arch = True
    auto_backup = True
    releasers = basic_releasers
    release_subscribers = ["mikari"]


class BsYetiLightConfigs(sdk2.Resource):
    """
    json configs for bsyeti (SelectType, KeywordInfo, CounterInfo, etc)
    """

    any_arch = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = basic_releasers


class MakeBsYetiLightConfigs(sdk2.Task):
    """
    task to build json configs for bsyeti
    """

    class Requirements(sdk2.Requirements):
        cores = 1  # exactly 1 core
        ram = 8192  # 8GiB or less
        client_tags = Tag.GENERIC & ~Tag.INTEL_E5645

    class Caches(sdk2.Requirements.Caches):
        pass  # means that task do not use any shared caches

    class Parameters(sdk2.Parameters):
        binary_id = sdk2.parameters.LastReleasedResource(
            "bsyeti make light configs binary resource",
            resource_type=BsYetiMakeLightConfigsBin,
            state=(ctr.State.READY,),
            required=True,
        )
        do_release = sdk2.parameters.Bool(
            "Make this resourse released (USE ONLY FOR SCHEDULERS!)",
            default=False,
            required=False,
            do_not_copy=True,
        )

    def on_execute(self):
        bin_res = sdk2.ResourceData(self.Parameters.binary_id)

        folder = "bsyeti-configs"
        os.mkdir(folder)
        env = {
            "YT_TOKEN": sdk2.Vault.data(
                "sec-01djab78jh9dvsymnjzwhk1mpf[yt_token]"
            ),  # "zomb-yeti" secret from yav
            "YQL_TOKEN": sdk2.Vault.data(
                "sec-01djab78jh9dvsymnjzwhk1mpf[yql_token]"
            ),  # "zomb-yeti" secret from yav
            "TMP": ".",
            "TMPDIR": ".",
        }
        cmd = [str(bin_res.path), "--output", folder]
        t = time.time()
        with sdk2.helpers.ProcessLog(self, logger="bsyeti_make_light_configs") as l:
            sp.check_call(cmd, stdout=l.stdout, stderr=l.stderr, env=env)
        dump_timestamp(folder, t)
        res = BsYetiLightConfigs(self, "BSYeti Light Configs", folder, ttl=14)
        if self.Parameters.do_release:
            res.released = "stable"
