# -*- coding: utf-8 -*-

import os
import time

import sandbox.common.types.resource as ctr
import sandbox.projects.resource_types as rt

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.bsyeti.common import dump_timestamp, basic_releasers, CatalogiaDssmModel


class BigbBuildGeoPermalinkDictBin(rt.ARCADIA_PROJECT):
    """
    resource with build map dict bin
    """

    releasable = True
    any_arch = True
    auto_backup = True
    releasers = basic_releasers
    release_subscribers = basic_releasers


class BigbGeoPermalinkDict(sdk2.Resource):
    """
    geo permalink dict for bigb
    """
    any_arch = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = basic_releasers


class MakeBigbGeoPermalinkDict(sdk2.Task):
    """
    task to build geo dict with permalinks
    """
    class Caches(sdk2.Requirements.Caches):
        pass  # means that task do not use any shared caches

    class Requirements(sdk2.Requirements):
        cores = 2  # exactly 2 cores
        ram = 50000

    class Parameters(sdk2.Parameters):
        binary_id = sdk2.parameters.LastReleasedResource(
            'build geo permalink dict binary resource',
            resource_type=BigbBuildGeoPermalinkDictBin,
            state=(ctr.State.READY, ),
            required=True
        )
        catalogia_id = sdk2.parameters.LastReleasedResource(
            'dssm catalogia',
            resource_type=CatalogiaDssmModel,
            state=(ctr.State.READY, ),
            required=True
        )
        do_release = sdk2.parameters.Bool(
            "Make this resourse released (USE ONLY FOR SCHEDULERS!)",
            default=False,
            required=False,
            do_not_copy=True
        )

    def on_execute(self):
        bin_res = sdk2.ResourceData(self.Parameters.binary_id)
        catalogia_res = sdk2.ResourceData(self.Parameters.catalogia_id)

        folder = "permalink_dict"
        os.mkdir(folder)
        env = {
            "YT_TOKEN": sdk2.Vault.data("sec-01djab78jh9dvsymnjzwhk1mpf[yt_token]"),  # "zomb-yeti" secret from yav
            "TMP": ".",
            "TMPDIR": ".",
        }
        cmd = [
            str(bin_res.path),
            "parse-companies",
            "-o", os.path.join(folder, "permalink_dict"),
            "-i", "//home/sprav/altay/prod/snapshot/company",
            "-r", "//home/sprav/altay/prod/snapshot/rubric",
            "-c", str(catalogia_res.path),

        ]
        t = time.time()
        with sdk2.helpers.ProcessLog(self, logger="bigb_make_geo_permalink_dict") as l:
            sp.check_call(cmd, stdout=l.stdout, stderr=l.stderr, env=env)
        dump_timestamp(folder, t)
        res = BigbGeoPermalinkDict(self, "BigbB Geo Permalink Dict", folder)
        if self.Parameters.do_release:
            res.released = 'stable'
