# -*- coding: utf-8 -*-

from sandbox import sdk2
import time
import sandbox.common.types.resource as ctr
import sandbox.projects.resource_types as rt

from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.bsyeti.common import dump_timestamp, basic_releasers


class BsYetiMakeHeavyBasesBin(rt.ARCADIA_PROJECT):
    """
    resource with make_bsyeti_bin_bases bin
    """

    releasable = True
    any_arch = True
    auto_backup = True
    releasers = basic_releasers
    release_subscribers = ["mikari"]


class BsYetiHeavyBases(sdk2.Resource):
    """
    heavy bases for bsyeti (matrixnets, models, bin bases, etc)
    """

    any_arch = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = basic_releasers


class MakeBsYetiHeavyBases(sdk2.Task):
    """
    task to build heavy bases for bsyeti
    """
    class Requirements(sdk2.Requirements):
        cores = 1  # exactly 1 core
        ram = 24576  # 8GiB or less

    class Caches(sdk2.Requirements.Caches):
        pass  # means that task do not use any shared caches

    class Parameters(sdk2.Parameters):
        binary_id = sdk2.parameters.LastReleasedResource(
            'bsyeti make heavy bases binary resource',
            resource_type=BsYetiMakeHeavyBasesBin,
            state=(ctr.State.READY, ),
            required=True
        )
        do_release = sdk2.parameters.Bool(
            "Make this resourse released (USE ONLY FOR SCHEDULERS!)",
            default=False,
            required=False,
            do_not_copy=True
        )

    def on_execute(self):
        bin_res = sdk2.ResourceData(self.Parameters.binary_id)

        folder = "bsyeti-bases"
        env = {
            "YT_TOKEN": sdk2.Vault.data("sec-01djab78jh9dvsymnjzwhk1mpf[yt_token]"),  # "zomb-yeti" secret from yav
            "YQL_TOKEN": sdk2.Vault.data("sec-01djab78jh9dvsymnjzwhk1mpf[yql_token]"),  # "zomb-yeti" secret from yav
            "TMP": ".",
            "TMPDIR": ".",
        }
        cmd = [
            str(bin_res.path),
            "--output", folder,
        ]
        t = time.time()
        with sdk2.helpers.ProcessLog(self, logger="make_bsyeti_bin_bases") as l:
            sp.check_call(cmd, stdout=l.stdout, stderr=l.stderr, env=env)
        dump_timestamp(folder, t)
        res = BsYetiHeavyBases(self, "BSYeti Heavy Bases", folder, ttl=14)
        if self.Parameters.do_release:
            res.released = 'stable'
