# -*- coding: utf-8 -*-

import os
import time
from datetime import datetime
from sandbox import sdk2
import sandbox.common.types.resource as ctr
import sandbox.projects.resource_types as rt

from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.bsyeti.common import dump_timestamp, basic_releasers


class BigbCountersIdfBase(sdk2.Resource):
    """
    bigb counters keys IDF base
    """
    any_arch = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = basic_releasers


class MakeBigbCountersIdfBaseBin(rt.ARCADIA_PROJECT):
    """
    resource with make_idf_counters_base bin
    """

    releasable = True
    any_arch = True
    auto_backup = True
    releasers = basic_releasers
    release_subscribers = ["bsyeti-watcher"]


class MakeBigbCountersIdfBase(sdk2.Task):
    """
    task to bigb counters idf bases for eagle
    """
    class Requirements(sdk2.Requirements):
        cores = 1  # exactly 1 core
        ram = 24576  # 8GiB or less

    class Caches(sdk2.Requirements.Caches):
        pass  # means that task do not use any shared caches

    class Parameters(sdk2.Parameters):
        binary_id = sdk2.parameters.LastReleasedResource(
            'bsyeti make idf counters base binary resource',
            resource_type=MakeBigbCountersIdfBaseBin,
            state=(ctr.State.READY, ),
            required=True
        )
        do_release = sdk2.parameters.Bool(
            "Make this resourse released (USE ONLY FOR SCHEDULERS!)",
            default=False,
            required=False,
            do_not_copy=True
        )

    def on_execute(self):
        bin_res = sdk2.ResourceData(self.Parameters.binary_id)

        bin_base_folder = "bsyeti-counters-idf-base"
        linear_models_folder = "bsyeti-counters-idf-linear-models"
        os.mkdir(bin_base_folder)
        env = {
            "YT_PROXY": "hahn",
            "YT_TOKEN": sdk2.Vault.data("sec-01djab78jh9dvsymnjzwhk1mpf[yt_token]"),  # "zomb-yeti" secret from yav
            "TMP": ".",
            "TMPDIR": ".",
        }
        cmd = [
            str(bin_res.path),
            "--bin-base-file", os.path.join(bin_base_folder, "idf_base.bin"),
            "--linear-models-output-path", linear_models_folder,
        ]
        t = time.time()
        with sdk2.helpers.ProcessLog(self, logger="make_bsyeti_counters_idf_bases") as l:
            sp.check_call(cmd, stdout=l.stdout, stderr=l.stderr, env=env)
        dump_timestamp(bin_base_folder, t)
        res = BigbCountersIdfBase(self, "BSYeti Counters IDF Base", bin_base_folder, ttl=90)
        if self.Parameters.do_release:
            res.released = 'stable'

        date_hour_str = datetime.now().strftime("%Y%m%d%H")

        for lm_id in os.listdir(linear_models_folder):
            lm_path = os.path.join(linear_models_folder, lm_id)
            dump_timestamp(lm_path, t)
            res = sdk2.Resource["ML_ENGINE_DUMP"](
                self,
                "BSYeti Counters IDF linear models: counter_id=%s" % lm_id,
                lm_path,
                ttl=90,
                engine="vw",
                last_log_date=date_hour_str,
                task_id="bigb_counter_%s_idfs" % lm_id
            )
            if self.Parameters.do_release:
                res.released = 'stable'
