# -*- coding: utf-8 -*-
import os

from sandbox import sdk2
import time
import sandbox.common.types.resource as ctr
import sandbox.projects.resource_types as rt

from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.bsyeti.common import dump_timestamp, basic_releasers


class BsYetiMakeMobileAppsBaseBin(rt.ARCADIA_PROJECT):
    """
    resource with make_bsyeti_mobile_apps_base bin
    """

    releasable = True
    any_arch = True
    auto_backup = True
    releasers = basic_releasers
    release_subscribers = ["bulatman", "bsyeti-watcher"]


class BsYetiMobileAppsBase(sdk2.Resource):
    """
    mobile apps base for bsyeti
    """

    any_arch = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = basic_releasers


class MakeBsYetiMobileAppsBase(sdk2.Task):
    """
    task to build mobile apps base for bsyeti
    """
    class Requirements(sdk2.Requirements):
        cores = 1  # exactly 1 core
        ram = 2048  # 2GiB or less

    class Caches(sdk2.Requirements.Caches):
        pass  # means that task do not use any shared caches

    class Parameters(sdk2.Parameters):
        binary_id = sdk2.parameters.LastReleasedResource(
            'bsyeti make mobile apps base binary resource',
            resource_type=BsYetiMakeMobileAppsBaseBin,
            state=(ctr.State.READY, ),
            required=True
        )
        do_release = sdk2.parameters.Bool(
            "Make this resourse released (USE ONLY FOR SCHEDULERS!)",
            default=False,
            required=False,
            do_not_copy=True
        )

    def on_execute(self):
        bin_res = sdk2.ResourceData(self.Parameters.binary_id)

        folder = "bsyeti-mobile-apps"
        env = {
            "YT_TOKEN": sdk2.Vault.data("sec-01djab78jh9dvsymnjzwhk1mpf[yt_token]"),  # "zomb-yeti" secret from yav
            "YQL_TOKEN": sdk2.Vault.data("sec-01djab78jh9dvsymnjzwhk1mpf[yql_token]"),  # "zomb-yeti" secret from yav
            "TMP": ".",
            "TMPDIR": ".",
        }
        cmd = [
            str(bin_res.path),
            "--output", folder
        ]
        t = time.time()
        os.mkdir(folder)
        with sdk2.helpers.ProcessLog(self, logger="make_bsyeti_mobile_apps_base") as l:
            sp.check_call(cmd, stdout=l.stdout, stderr=l.stderr, env=env)
        dump_timestamp(folder, t)
        res = BsYetiMobileAppsBase(self, "BSYeti Mobile Apps Base", folder, ttl=90)
        if self.Parameters.do_release:
            res.released = 'stable'
