# -*- coding: utf-8 -*-

from sandbox import sdk2
import sandbox.common.types.resource as ctr
import sandbox.projects.resource_types as rt

from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.bsyeti.common import basic_releasers


class MakeSampledCatalogiaQueriesBin(rt.ARCADIA_PROJECT):
    """
    resource with sample_catalogia_queries bin
    """

    releasable = True
    any_arch = True
    auto_backup = True
    releasers = basic_releasers
    release_subscribers = ["pechatnov"]


class MakeSampledCatalogiaQueries(sdk2.Task):
    """
    task to make sampled catalogia queries
    for learning dssm model
    """
    class Requirements(sdk2.Requirements):
        cores = 1  # exactly 1 core
        ram = 8192  # 8GiB or less

    class Caches(sdk2.Requirements.Caches):
        pass  # means that task do not use any shared caches

    class Parameters(sdk2.Parameters):
        binary_id = sdk2.parameters.LastReleasedResource(
            'bsyeti make sampled catalogia queries binary resource',
            resource_type=MakeSampledCatalogiaQueriesBin,
            state=(ctr.State.READY, ),
            required=True
        )

        output_sampled_queries_table = sdk2.parameters.String(
            'output sampled queries table',
            default="//home/bs/bsyeti/catalogia/sampled_queries",
            required=True
        )

        output_labeled_queries_table = sdk2.parameters.String(
            'output labeled queries table',
            default="//home/bs/bsyeti/catalogia/labeled_queries",
            required=True
        )

        weighted_queries_tables_dir = sdk2.parameters.String(
            'weighted queries tables dir',
            default="//home/bs/bsyeti/catalogia/weighted_queries",
            required=True
        )

    def on_execute(self):
        bin_res = sdk2.ResourceData(self.Parameters.binary_id)

        env = {
            "YT_PROXY": "hahn",
            "YT_TOKEN": sdk2.Vault.data("sec-01djadg0mrt0pwjdc6yewr2967[yt_token]"),  # "robot-yeti-v-nirvane" secret from yav
            "YQL_TOKEN": sdk2.Vault.data("sec-01djadg0mrt0pwjdc6yewr2967[yql_token]"),  # "robot-yeti-v-nirvane" secret from yav
        }
        print "Env lengths: ", list((k, len(v)) for k, v in env.items())
        cmd = [
            str(bin_res.path) + "/sample_catalogia_queries",
            "--output_sampled_queries_table", self.Parameters.output_sampled_queries_table,
            "--output_labeled_queries_table", self.Parameters.output_labeled_queries_table,
            "--weighted_queries_tables_dir", self.Parameters.weighted_queries_tables_dir,
        ]
        with sdk2.helpers.ProcessLog(self, logger="make_sampled_catalogia_queries") as l:
            sp.check_call(cmd, stdout=l.stdout, stderr=l.stderr, env=env)
