# -*- coding: utf-8 -*-

from sandbox import sdk2
import os
import time
import sandbox.common.types.resource as ctr
import sandbox.projects.resource_types as rt

from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.bsyeti.common import dump_timestamp, basic_releasers


class BsYetiBuildSovetnikDictBin(rt.ARCADIA_PROJECT):
    """
    resource with build sovetnik dict bin
    """

    releasable = True
    any_arch = True
    auto_backup = True
    releasers = basic_releasers
    release_subscribers = ["mikari"]


class BsYetiSovetnikDict(sdk2.Resource):
    """
    sovetnik dict
    """
    any_arch = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = basic_releasers


class MakeBsYetiSovetnikDict(sdk2.Task):
    """
    task to build json configs for bsyeti
    """
    class Caches(sdk2.Requirements.Caches):
        pass  # means that task do not use any shared caches

    class Requirements(sdk2.Requirements):
        cores = 2  # exactly 2 cores
        ram = 50000

    class Parameters(sdk2.Parameters):
        binary_id = sdk2.parameters.LastReleasedResource(
            'build sovetnik dict binary resource',
            resource_type=BsYetiBuildSovetnikDictBin,
            state=(ctr.State.READY, ),
            required=True
        )
        do_release = sdk2.parameters.Bool(
            "Make this resourse released (USE ONLY FOR SCHEDULERS!)",
            default=False,
            required=False,
            do_not_copy=True
        )

    def on_execute(self):
        bin_res = sdk2.ResourceData(self.Parameters.binary_id)

        folder = "sovetnik"
        os.mkdir(folder)
        env = {
            "YT_TOKEN": sdk2.Vault.data("sec-01djab78jh9dvsymnjzwhk1mpf[yt_token]"),  # "zomb-yeti" secret from yav
            "TMP": ".",
            "TMPDIR": ".",
        }
        cmd = [
            str(bin_res.path),
            "build-sovetnik-dict",
            "-o", os.path.join(folder, "sovetnik"),
        ]
        t = time.time()
        with sdk2.helpers.ProcessLog(self, logger="bsyet_make_sovetnik_dict") as l:
            sp.check_call(cmd, stdout=l.stdout, stderr=l.stderr, env=env)
        dump_timestamp(folder, t)
        res = BsYetiSovetnikDict(self, "BsYeti Sovetnik Dict", folder)
        if self.Parameters.do_release:
            res.released = 'stable'
