# -*- coding: utf-8 -*-

from sandbox import sdk2
import sandbox.common.types.resource as ctr
import sandbox.projects.resource_types as rt

from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.bsyeti.common import basic_releasers


class BigbVultureBin(rt.ARCADIA_PROJECT):
    """
    vulture execution binary file
    """

    releasable = True
    any_arch = True
    auto_backup = True
    releasers = basic_releasers
    release_subscribers = ["cberg, mikari"]


class RunBigbVulture(sdk2.Task):
    """
    task that run vulture process
    """
    class Requirements(sdk2.Requirements):
        cores = 1  # exactly 1 core
        ram = 8192  # 8GiB or less

    class Caches(sdk2.Requirements.Caches):
        pass  # means that task do not use any shared caches

    class Parameters(sdk2.Parameters):
        binary_id = sdk2.parameters.LastReleasedResource(
            'Run Vulture - collect and send data',
            resource_type=BigbVultureBin,
            state=(ctr.State.READY, ),
            required=True
        )
        config_name = sdk2.parameters.String(
            "Config name and env",
            required=True,
            do_not_copy=True
        )

    def on_execute(self):
        bin_res = sdk2.ResourceData(self.Parameters.binary_id)
        env = {
            "YT_TOKEN": sdk2.Vault.data("sec-01djae5p7at7jjs7wvzma5zd7k[yt_token]"),  # "robot-vulture" secret from yav
            "YT_USER": "robot-vulture",
        }
        cmd = [
            str(bin_res.path),
            "--config", "/configs/" + self.Parameters.config_name,
        ]
        with sdk2.helpers.ProcessLog(self, logger="bigb_vulture") as logger:
            sp.check_call(cmd, stdout=logger.stdout, stderr=logger.stderr, env=env)
