# -*- coding: utf-8 -*-

import os
import time

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.common.arcadia.sdk import mount_arc_path
from sandbox.projects.common import solomon
from sandbox.projects.bsyeti.common import get_yt_token_path


class UpdateBigbSolomonJugglerAlertsAndDashboards(sdk2.Task):
    """
    task to update bigb solomon and juggler alerts
    """

    class Requirements(sdk2.Requirements):
        cores = 4
        ram = 8000

    class Parameters(sdk2.Parameters):

        project = sdk2.parameters.String(
            "Project (empty means all projects)",
            required=False,
        )

        dry_run = sdk2.parameters.Bool(
            "Do not affect anything",
            default=True,
        )

        solomon_tag = sdk2.parameters.String(
            "Tag for solomon metrics",
            default="test",
        )

    def on_execute(self):
        env = dict(os.environ)
        env["JUGGLER_OAUTH_TOKEN"] = sdk2.Vault.data(
            "sec-01djab78jh9dvsymnjzwhk1mpf[juggler_token]"
        )  # zomb-yeti token
        env["SOLOMON_OAUTH_TOKEN"] = sdk2.Vault.data(
            "sec-01djab78jh9dvsymnjzwhk1mpf[solomon_token]"
        )  # zomb-yeti token
        # for solo
        env["JUGGLER_TOKEN"] = sdk2.Vault.data(
            "sec-01djab78jh9dvsymnjzwhk1mpf[juggler_token]"
        )  # zomb-yeti token
        env["SOLOMON_TOKEN"] = sdk2.Vault.data(
            "sec-01djab78jh9dvsymnjzwhk1mpf[solomon_token]"
        )  # zomb-yeti token
        env["YT_TOKEN"] = sdk2.Vault.data(
            "sec-01djab78jh9dvsymnjzwhk1mpf[yt_token]"
        )  # zomb-yeti token

        with mount_arc_path("arcadia-arc:/#trunk") as arcadia_src_dir:
            params = []
            if self.Parameters.project:
                params += ["-p", self.Parameters.project]
            if not self.Parameters.dry_run:
                params += ["-r"]

            env["PATH"] += ":" + arcadia_src_dir

            with sdk2.helpers.ProcessLog(
                self, logger="update_juggler_solomon_alerts_and_dashboards"
            ) as l:
                os.chdir(os.path.join(arcadia_src_dir, "ads/bsyeti/tools/solomon"))
                sp.check_call(
                    [
                        "ya",
                        "make",
                        "-r",
                        "dashboards",
                        "--yt-token-path",
                        get_yt_token_path(),
                    ],
                    env=env,
                    stdout=l.stdout,
                    stderr=l.stderr,
                )
                sp.check_call(
                    ["./dashboards/dashboards"] + params,
                    env=env,
                    stdout=l.stdout,
                    stderr=l.stderr,
                )

            with sdk2.helpers.ProcessLog(self, logger="update_solo") as l:
                os.chdir(os.path.join(arcadia_src_dir, "ads/bsyeti/tools/solo"))
                sp.check_call(
                    [
                        "ya",
                        "make",
                        "-r",
                        "creator",
                        "--yt-token-path",
                        get_yt_token_path(),
                    ],
                    env=env,
                    stdout=l.stdout,
                    stderr=l.stderr,
                )
                sp.check_call(
                    ["./creator/creator", "--apply-changes", "--delete-untracked"],
                    env=env,
                    stdout=l.stdout,
                    stderr=l.stderr,
                )

        solomon.push_to_solomon_v2(
            token=sdk2.Vault.data(
                "sec-01djab78jh9dvsymnjzwhk1mpf[solomon_token]"
            ),  # zomb-yeti token
            params={
                "project": "bsyeti",
                "cluster": "sandbox_tasks",
                "service": "sandbox_tasks",
            },
            sensors=[
                {
                    "labels": {
                        "task": "UPDATE_BIGB_SOLOMON_JUGGLER_ALERTS_AND_DASHBOARDS",
                        "tag": self.Parameters.solomon_tag,
                        "sensor": sensor,
                    },
                    "ts": int(time.time()),
                    "value": value,
                }
                for sensor, value in [
                    (
                        "success",
                        1,
                    )
                ]
            ],
        )
