from sandbox import sdk2
from sandbox.projects.common.nanny import nanny
from sandbox.projects.cajuper.common import index_state_types


class BuildIndexStateFile(nanny.ReleaseToNannyTask2, sdk2.Task):
    """
    Create resource with search index state
    """

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.RadioGroup('State for project', required=True) as state_for_project:
            for project in index_state_types.RESOURCES_BY_PROJECTS.keys():
                state_for_project.values[project] = state_for_project.Value(value=project)

        db_timestamp = sdk2.parameters.Integer('DB timestamp', required=True)

    def on_execute(self):
        self.hint(self.Parameters.db_timestamp)
        for generator in index_state_types.RESOURCES_BY_PROJECTS[self.Parameters.state_for_project]:
            resource_data = sdk2.ResourceData(
                generator.get_resource_type()(
                    self,
                    '{} DB state {}'.format(
                        self.Parameters.state_for_project,
                        self.Parameters.db_timestamp
                    ),
                    generator.get_filename(),
                )
            )
            resource_data.path.write_bytes(generator.get_content(self.Parameters.db_timestamp))
            resource_data.ready()

    def on_release(self, additional_parameters):
        with self.memoize_stage.nanny_release(commit_on_entrance=False):
            nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)

        with self.memoize_stage.do_release(commit_on_entrance=False):
            sdk2.Task.on_release(self, additional_parameters)
