# -*- coding: utf-8 -*-
from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects.common.ya_deploy import release_integration
import sandbox.projects.cajuper.resources as resource_types

RESOURCE_TYPES = [
    resource_types.CallistoAllPrograms,
    resource_types.CallistoInstanceCtlHelper,
    resource_types.CallistoYasmSubAgent,
    resource_types.CallistoYtNodeCHecker,
    resource_types.CajuperTrackerClient,
]


class BuildInfraCallisto(YaMakeTemplate.YaMakeTemplate, release_integration.ReleaseToYaDeployTask2):
    """
        Build all callisto programs
    """
    class Parameters(YaMakeTemplate.get_project_params(RESOURCE_TYPES)):
        pass

    def on_release(self, additional_parameters):
        release_integration.ReleaseToYaDeployTask2.on_release(self, additional_parameters)
        YaMakeTemplate.YaMakeTemplate.on_release(self, additional_parameters)
