import os

from sandbox import sdk2
from sandbox.projects.common.dolbilka2 import DolbilkaPlanner2
from sandbox.projects.cajuper import resources
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk import process


YT_PATH_TEMPLATE = '//home/eventlogdata/MsuseardataJupiterTier0'
YT_SCRIPT = 'yt_requests_prepare.py'


class BuildWebMmetaHeaterPlan(sdk2.Task):
    """
    Create resource with search index state
    """

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.RadioGroup('Yt cluster') as yt_cluster:
            yt_cluster.values['arnold'] = yt_cluster.Value(value='Arnold')
            yt_cluster.values['hahn'] = yt_cluster.Value(value='Hahn', default=True)

        plan_size = sdk2.parameters.Integer('Queries number', default=10000)

    class Requirements(sdk2.Task.Requirements):
        environments = (
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
        )

    def on_execute(self):
        import yt.wrapper as yt

        yt.config['proxy']['url'] = self.Parameters.yt_cluster
        yt.config['token'] = sdk2.Vault.data(self.owner, 'yt-token')

        yt_path_root = YT_PATH_TEMPLATE

        date_table = sorted(yt.list(yt_path_root)).pop()

        self.Context.source_table = yt_path_root + '/' + date_table

        with self.memoize_stage.create_output_table(commit_on_entrance=False):
            self.Context.output_table = yt.create_temp_table(expiration_timeout=60 * 60 * 1000)

        with self.memoize_stage.fill_output_table(commit_on_entrance=False):
            process.run_process(
                cmd=[
                    '/skynet/python/bin/python',
                    os.path.join(os.path.dirname(__file__), YT_SCRIPT),
                    '--yt-proxy', self.Parameters.yt_cluster,
                    '--source-table', self.Context.source_table,
                    '--output-table', self.Context.output_table,
                ],
                wait=True,
                check=True,
                environment=dict(
                    os.environ,
                    YT_TOKEN=yt.config['token']
                )
            )

        requests_filename = os.path.join(os.getcwd(), 'requests.txt')

        with open(requests_filename, 'w') as fp:
            filtered_requests = yt.read_table(
                self.Context.output_table + '[:#{}]'.format(self.Parameters.plan_size),
                format=yt.format.JsonFormat()
            )

            fp.writelines(
                row['request'] + '\n' for row in filtered_requests
            )
            assert fp.tell() > 4 * 1024 * self.Parameters.plan_size, 'Have got too few queries from YT'

        plan_filename = os.path.join(os.getcwd(), 'heater.mmeta.plan')

        planner = DolbilkaPlanner2()
        planner.create_plan(
            requests_filename,
            result_path=plan_filename,
            rps=250,
            loader_type='plain',
        )

        resource = sdk2.ResourceData(resources.HeaterMmetaPlan(
            self,
            'Heater basesearch plan for Mmeta',
            os.path.basename(plan_filename),
            ttl=30
        ))
        resource.ready()
