import argparse
import os

import yt.wrapper as yt


def get_only_context_created(row):
    if row.get('event_type') == 'ContextCreated':
        yield {'request': 'http://localhost:8030/yandsearch?={}&nocache=da'.format(row['event_data'].split()[0])}


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', help='YT proxy', required=True)
    parser.add_argument('--source-table', help='Source table', required=True)
    parser.add_argument('--output-table', help='Output table', required=True)

    return parser.parse_args()


def main():
    args = parse_args()

    yt.config['proxy']['url'] = args.yt_proxy
    yt.config['pickling']['python_binary'] = '/skynet/python/bin/python'
    yt.config['token'] = os.environ.get('YT_TOKEN')

    yt.run_map(get_only_context_created, args.source_table, args.output_table)


if __name__ == '__main__':
    main()
