# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.common.types import task

import sandbox.projects.cajuper.resources as resource_types
import sandbox.projects.cajuper.common.switch as switch

BUILD_TARGETS = (
    resource_types.WebRuntimeEmbeddingDeployLayer,
    resource_types.WebRuntimeIntDeployLayer,
    resource_types.WebRuntimeIntL2DeployLayer,
    resource_types.WebRuntimeInvIndexDeployLayer,
    resource_types.WebRuntimeKeyInvTier0DeployLayer,
    resource_types.WebRuntimePlatinumDeployLayer,
    resource_types.WebRuntimeTier0DeployLayer,
    resource_types.WebRuntimeTier1DeployLayer
)


class BuildWebRuntimeLayer(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.CheckGroup("Build layers", required=True) as build_targets:
            for resource in BUILD_TARGETS:
                build_targets.values[resource.name] = build_targets.Value(
                    resource.name, checked=True
                )

    def on_execute(self):
        assert len(self.Parameters.build_targets) > 0, 'No layer selected'

        build_package = filter(
            lambda x: x in self.Parameters.build_targets,
            BUILD_TARGETS
        )

        with self.memoize_stage.create_subtasks(commit_on_entrance=False):
            package_build_task = sdk2.Task["YA_PACKAGE"](
                self,
                description="Package builder",
                use_aapi_fuse=True,
                aapi_fallback=True,
                package_type='tarball',
                release_to_ya_deploy=True,
                packages=';'.join(t.arcadia_build_path for t in build_package),
                resource_type=';'.join(t.name for t in build_package)
            )
            package_build_task.enqueue()
            self.Context.package_builder_id = package_build_task.id

            raise sdk2.WaitTask(
                [self.Context.package_builder_id],
                task.Status.Group.FINISH | task.Status.Group.BREAK,
                wait_all=True
            )

        for resource_type in build_package:
            switch.copy_resource(
                self,
                switch.find_resource(
                    self.Context.package_builder_id,
                    resource_type
                )
            )

    def on_release(self, parameters):
        self.server.release(
            task_id=self.Context.package_builder_id,
            subject=parameters['release_subject'],
            type=parameters['release_status'],
            message=parameters['release_comments']
        )
        super(BuildWebRuntimeLayer, self).on_release(parameters)
