# coding=utf-8
from sandbox import sdk2

import jinja2
import requests


DB_SWITCH_RECIPE_URL = '/infra/nanny/alemate/recipes/dashboard_db_switch.yaml'


class CheckWebDbSwitchRecipe(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        nanny_token = sdk2.parameters.Vault(
            "Nanny token",
            description="'name' or 'owner:name' for extracting from Vault",
            default=sdk2.VaultItem('SEARCH-RELEASERS', 'nanny_oauth_token'),
            required=True
        )

    def on_execute(self):
        nanny_token = self.Parameters.nanny_token.data()

        balancers_known_sections, actions_config = self._get_recipe_balancer_data()
        self.Context.balancers_known_sections = balancers_known_sections
        self.Context.actions_config = actions_config

        its_balancers_info = {
            balancer: self._get_its_balancer_weights(balancer, nanny_token)
            for balancer in balancers_known_sections
        }

        self.Context.its_balancers_info = its_balancers_info

    def _get_its_balancer_weights(self, balancer, oauth_token):
        nanny_url = 'http://ext.its.yandex-team.ru/v2/l7/heavy/{balancer_name}/weights/values/'
        self.session = requests.Session()
        self.session.headers['Authorization'] = 'OAuth {}'.format(oauth_token)
        self.session.headers['Content-Type'] = 'application/json'

        return self.session.get(nanny_url.format(balancer_name=balancer)).json()

    def _get_recipe_balancer_data(self):
        template_source = sdk2.vcs.svn.Arcadia.cat(
            sdk2.vcs.svn.Arcadia.ARCADIA_TRUNK_URL + DB_SWITCH_RECIPE_URL
        )

        return self._parse_recipe(template_source)

    def _parse_recipe(self, recipe_template):
        env = jinja2.Environment()
        parsed_content = env.parse(recipe_template)

        balancers_known_sections = {}
        actions_config = {}
        for node in parsed_content.find_all(jinja2.nodes.Assign):
            if node.target.ctx == 'store':
                if node.target.name == 'l7_locations':
                    actions_config = node.node.as_const()
                if node.target.name == 'l7_known_sections':
                    balancers_known_sections = node.node.as_const()

        return balancers_known_sections, actions_config
