from sandbox.projects.cajuper import resources

import datetime
import json


class _IndexStateGenerator(object):
    _filename = None
    _resource_type = None
    _namespace_prefix = None

    @classmethod
    def get_filename(cls):
        if cls._filename:
            return cls._filename
        raise NotImplementedError('Resource filename is not defined')

    @classmethod
    def get_resource_type(cls):
        if cls._resource_type:
            return cls._resource_type
        raise NotImplementedError('Resource type is not defined')

    @classmethod
    def get_namespace_prefix(cls):
        if cls._namespace_prefix:
            return cls._namespace_prefix
        raise NotImplementedError('Namespace prefix is not defined')

    @classmethod
    def get_content(cls, db_timestamp):
        raise NotImplementedError('Content is not defined')


class _ShellIndexStateGenerator(_IndexStateGenerator):
    _filename = 'vars.conf'

    @classmethod
    def get_content(cls, db_timestamp):
        return (
            'export DB_TIMESTAMP={}\n'
            'export YT_STATE={}\n'
            'export NAMESPACE_PREFIX={}\n'
        ).format(
            db_timestamp,
            timestamp_to_yt_state(db_timestamp),
            cls.get_namespace_prefix().lower()
        )


class _JsonIndexStateGenerator(_IndexStateGenerator):
    _filename = 'vars.json'

    @classmethod
    def get_content(cls, db_timestamp):
        return json.dumps(
            {
                'DB_TIMESTAMP': db_timestamp,
                'YT_STATE': timestamp_to_yt_state(db_timestamp),
                'NAMESPACE_PREFIX': cls.get_namespace_prefix().lower(),
            },
            indent=2
        )


class ImagesProdShellIndexStateGenerator(_ShellIndexStateGenerator):
    _resource_type = resources.ImagesProductionIndexStateResource
    _namespace_prefix = 'images/prod'


class ImagesProdJsonIndexStateGenerator(_JsonIndexStateGenerator):
    _resource_type = resources.ImagesProductionIndexStateJsonResource
    _namespace_prefix = 'images/prod'


class RimProdShellIndexStateGenerator(_ShellIndexStateGenerator):
    _resource_type = resources.ImagesRimProductionIndexStateResource
    _namespace_prefix = 'images/prod/rim'


class RimProdJsonIndexStateGenerator(_JsonIndexStateGenerator):
    _resource_type = resources.ImagesRimProductionIndexStateJsonResource
    _namespace_prefix = 'images/prod/rim'


class ImagesCommercialProdShellIndexStateGenerator(_ShellIndexStateGenerator):
    _resource_type = resources.ImagesCommercialProductionIndexStateResource
    _namespace_prefix = 'images/prod/commercial'


class VideoProdShellIndexStateGenerator(_ShellIndexStateGenerator):
    _resource_type = resources.VideoProductionIndexStateResource
    _namespace_prefix = 'video/prod'


class VideoProdJsonIndexStateGenerator(_JsonIndexStateGenerator):
    _resource_type = resources.VideoProductionIndexStateJsonResource
    _namespace_prefix = 'video/prod'


class WebProdShellIndexStateGenerator(_ShellIndexStateGenerator):
    _resource_type = resources.WebProductionIndexStateResource
    _namespace_prefix = 'web/prod'


class WebProdJsonIndexStateGenerator(_JsonIndexStateGenerator):
    _resource_type = resources.WebProductionIndexStateJsonResource
    _namespace_prefix = 'web/prod'


class WebProdYtShellIndexStateGenerator(_ShellIndexStateGenerator):
    _filename = 'vars_yt.conf'
    _resource_type = resources.WebProductionYtIndexStateResource
    _namespace_prefix = 'web/prod/yt'


class WebProdYtJsonIndexStateGenerator(_JsonIndexStateGenerator):
    _filename = 'vars_yt.json'
    _resource_type = resources.WebProductionYtIndexStateJsonResource
    _namespace_prefix = 'web/prod/yt'


class WebProdYtBeta1ShellIndexStateGenerator(_ShellIndexStateGenerator):
    _filename = 'vars_yt_beta1.conf'
    _resource_type = resources.WebProductionYtBeta1IndexStateResource
    _namespace_prefix = 'web/prod/yt/beta1'


class WebProdYtBeta1JsonIndexStateGenerator(_JsonIndexStateGenerator):
    _filename = 'vars_yt_beta1.json'
    _resource_type = resources.WebProductionYtBeta1IndexStateJsonResource
    _namespace_prefix = 'web/prod/yt/beta1'


class WebProdYtBeta2ShellIndexStateGenerator(_ShellIndexStateGenerator):
    _filename = 'vars_yt_beta2.conf'
    _resource_type = resources.WebProductionYtBeta2IndexStateResource
    _namespace_prefix = 'web/prod/yt/beta2'


class WebProdYtBeta2JsonIndexStateGenerator(_JsonIndexStateGenerator):
    _filename = 'vars_yt_beta2.json'
    _resource_type = resources.WebProductionYtBeta2IndexStateJsonResource
    _namespace_prefix = 'web/prod/yt/beta2'


class WebProdYtBeta3ShellIndexStateGenerator(_ShellIndexStateGenerator):
    _filename = 'vars_yt_beta3.conf'
    _resource_type = resources.WebProductionYtBeta3IndexStateResource
    _namespace_prefix = 'web/prod/yt/beta3'


class WebProdYtBeta3JsonIndexStateGenerator(_JsonIndexStateGenerator):
    _filename = 'vars_yt_beta3.json'
    _resource_type = resources.WebProductionYtBeta3IndexStateJsonResource
    _namespace_prefix = 'web/prod/yt/beta3'


class WebProdYtBeta4ShellIndexStateGenerator(_ShellIndexStateGenerator):
    _filename = 'vars_yt_beta4.conf'
    _resource_type = resources.WebProductionYtBeta4IndexStateResource
    _namespace_prefix = 'web/prod/yt/beta4'


class WebProdYtBeta4JsonIndexStateGenerator(_JsonIndexStateGenerator):
    _filename = 'vars_yt_beta4.json'
    _resource_type = resources.WebProductionYtBeta4IndexStateJsonResource
    _namespace_prefix = 'web/prod/yt/beta4'


class WebProdYtBeta5ShellIndexStateGenerator(_ShellIndexStateGenerator):
    _filename = 'vars_yt_beta5.conf'
    _resource_type = resources.WebProductionYtBeta5IndexStateResource
    _namespace_prefix = 'web/prod/yt/beta5'


class WebProdYtBeta5JsonIndexStateGenerator(_JsonIndexStateGenerator):
    _filename = 'vars_yt_beta5.json'
    _resource_type = resources.WebProductionYtBeta5IndexStateJsonResource
    _namespace_prefix = 'web/prod/yt/beta5'


def timestamp_to_yt_state(ts):
    return datetime.datetime.fromtimestamp(int(ts)).strftime('%Y%m%d-%H%M%S')


RESOURCES_BY_PROJECTS = {
    'IMAGES/COMMERCIAL': [
        ImagesCommercialProdShellIndexStateGenerator,
    ],
    'IMAGES/RIM': [
        RimProdShellIndexStateGenerator,
    ],
    'IMAGES': [
        ImagesProdShellIndexStateGenerator,
        ImagesProdJsonIndexStateGenerator,
    ],
    'VIDEO': [
        VideoProdShellIndexStateGenerator,
        VideoProdJsonIndexStateGenerator,
    ],
    'WEB': [
        WebProdShellIndexStateGenerator,
        WebProdJsonIndexStateGenerator,
        WebProdYtShellIndexStateGenerator,
        WebProdYtJsonIndexStateGenerator,
        WebProdYtBeta1ShellIndexStateGenerator,
        WebProdYtBeta1JsonIndexStateGenerator,
        WebProdYtBeta2ShellIndexStateGenerator,
        WebProdYtBeta2JsonIndexStateGenerator,
        WebProdYtBeta3ShellIndexStateGenerator,
        WebProdYtBeta3JsonIndexStateGenerator,
        WebProdYtBeta4ShellIndexStateGenerator,
        WebProdYtBeta4JsonIndexStateGenerator,
        WebProdYtBeta5ShellIndexStateGenerator,
        WebProdYtBeta5JsonIndexStateGenerator,
    ],
}
